/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.SqlServerChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.SqlServerChatMemoryRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={SqlServerChatMemoryRepository.class, DataSource.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.sqlserver", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={SqlServerChatMemoryProperties.class})
public class SqlServerChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="sqlServerChatMemoryRepository")
    @ConditionalOnMissingBean(name={"sqlServerChatMemoryRepository"})
    SqlServerChatMemoryRepository sqlServerChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring SQL Server chat memory repository");
        return SqlServerChatMemoryRepository.sqlServerBuilder().jdbcTemplate(jdbcTemplate).build();
    }
}

