/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.MysqlChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.MysqlChatMemoryRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={MysqlChatMemoryRepository.class, DataSource.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.mysql", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={MysqlChatMemoryProperties.class})
public class MysqlChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MysqlChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="mysqlChatMemoryRepository")
    @ConditionalOnMissingBean(name={"mysqlChatMemoryRepository"})
    MysqlChatMemoryRepository mysqlChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring MySQL chat memory repository");
        return MysqlChatMemoryRepository.mysqlBuilder().jdbcTemplate(jdbcTemplate).build();
    }
}

