/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;

public class RedisChatMemoryConnectionDetails
implements RedisConnectionDetails {
    private final RedisChatMemoryProperties properties;

    public RedisChatMemoryConnectionDetails(RedisChatMemoryProperties properties) {
        this.properties = properties;
    }

    public String getUsername() {
        return this.properties.getUsername();
    }

    public String getPassword() {
        return this.properties.getPassword();
    }

    public RedisConnectionDetails.Standalone getStandalone() {
        return RedisConnectionDetails.Standalone.of((String)this.properties.getHost(), (int)this.properties.getPort());
    }

    public RedisConnectionDetails.Cluster getCluster() {
        RedisChatMemoryProperties.Cluster cluster = this.properties.getCluster();
        List<RedisConnectionDetails.Node> nodes = cluster != null ? cluster.getNodes().stream().map(this::asNode).toList() : null;
        return nodes != null ? () -> nodes : null;
    }

    private RedisConnectionDetails.Node asNode(String node) {
        int portSeparatorIndex = node.lastIndexOf(58);
        String host = node.substring(0, portSeparatorIndex);
        int port = Integer.parseInt(node.substring(portSeparatorIndex + 1));
        return new RedisConnectionDetails.Node(host, port);
    }
}

