/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.PostgresChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.PostgresChatMemoryRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={PostgresChatMemoryRepository.class, DataSource.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.postgres", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={PostgresChatMemoryProperties.class})
public class PostgresChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PostgresChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="postgresChatMemoryRepository")
    @ConditionalOnMissingBean(name={"postgresChatMemoryRepository"})
    PostgresChatMemoryRepository postgresChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring PostgreSQL chat memory repository");
        return PostgresChatMemoryRepository.postgresBuilder().jdbcTemplate(jdbcTemplate).build();
    }
}

