/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowAgentBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelAgent
extends FlowAgent {
    private static final Logger logger = LoggerFactory.getLogger(ParallelAgent.class);
    private final MergeStrategy mergeStrategy;
    private String mergeOutputKey;
    private final Integer maxConcurrency;

    protected ParallelAgent(ParallelAgentBuilder builder) {
        super(builder.name, builder.description, builder.compileConfig, builder.subAgents, builder.stateSerializer, builder.executor);
        this.mergeStrategy = builder.mergeStrategy != null ? builder.mergeStrategy : new DefaultMergeStrategy();
        this.maxConcurrency = builder.maxConcurrency;
        this.mergeOutputKey = builder.mergeOutputKey;
    }

    public static ParallelAgentBuilder builder() {
        return new ParallelAgentBuilder();
    }

    @Override
    protected StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        config.customProperty("mergeStrategy", this.mergeStrategy);
        config.customProperty("maxConcurrency", this.maxConcurrency);
        return FlowGraphBuilder.buildGraph(FlowAgentEnum.PARALLEL.getType(), config);
    }

    public MergeStrategy mergeStrategy() {
        return this.mergeStrategy;
    }

    public String mergeOutputKey() {
        return this.mergeOutputKey;
    }

    public Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public static class ParallelAgentBuilder
    extends FlowAgentBuilder<ParallelAgent, ParallelAgentBuilder> {
        private MergeStrategy mergeStrategy;
        private Integer maxConcurrency;
        private String mergeOutputKey;

        public ParallelAgentBuilder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        public ParallelAgentBuilder mergeOutputKey(String mergeOutputKey) {
            this.mergeOutputKey = mergeOutputKey;
            return this;
        }

        @Override
        public ParallelAgentBuilder subAgents(List<Agent> subAgents) {
            if (subAgents == null || subAgents.isEmpty()) {
                throw new IllegalArgumentException("Sub-agents must be provided");
            }
            if (subAgents.stream().anyMatch(agent -> !(agent instanceof BaseAgent))) {
                throw new IllegalArgumentException("Sub-agents must be BaseAgent");
            }
            return (ParallelAgentBuilder)super.subAgents(subAgents);
        }

        public ParallelAgentBuilder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        protected ParallelAgentBuilder self() {
            return this;
        }

        @Override
        protected void validate() {
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new IllegalArgumentException("Name must be provided");
            }
            if (this.subAgents == null || this.subAgents.size() < 2) {
                throw new IllegalArgumentException("ParallelAgent requires at least 2 sub-agents for parallel execution, but got: " + (this.subAgents != null ? this.subAgents.size() : 0));
            }
            if (this.subAgents.size() > 10) {
                throw new IllegalArgumentException("ParallelAgent supports maximum 10 sub-agents for performance reasons, but got: " + this.subAgents.size());
            }
            this.validateUniqueOutputKeys();
            this.validateInputKeyCompatibility();
            if (this.maxConcurrency != null && this.maxConcurrency < 1) {
                throw new IllegalArgumentException("maxConcurrency must be at least 1, but got: " + this.maxConcurrency);
            }
        }

        private void validateUniqueOutputKeys() {
            HashSet<String> outputKeys = new HashSet<String>();
            HashSet<String> duplicateKeys = new HashSet<String>();
            for (Agent subAgent : this.subAgents) {
                ReactAgent subReactAgent;
                String outputKey;
                if (!(subAgent instanceof ReactAgent) || (outputKey = (subReactAgent = (ReactAgent)subAgent).getOutputKey()) == null || outputKeys.add(outputKey)) continue;
                duplicateKeys.add(outputKey);
            }
            if (!duplicateKeys.isEmpty()) {
                throw new IllegalArgumentException("ParallelAgent validation failed: Duplicate output keys found among sub-agents: " + duplicateKeys + ". Each sub-agent must have a unique output key to avoid conflicts during result merging.");
            }
        }

        private void validateInputKeyCompatibility() {
            for (Agent subAgent : this.subAgents) {
                String subAgentOutputKey;
                if (!(subAgent instanceof ReactAgent) || (subAgentOutputKey = ((ReactAgent)subAgent).getOutputKey()) != null) continue;
                logger.warn("Sub-agent '{}' has no outputKey defined. This may cause data flow issues as downstream agents won't receive data from this agent.", (Object)subAgent.name());
            }
        }

        @Override
        public ParallelAgent doBuild() {
            this.validate();
            return new ParallelAgent(this);
        }
    }

    public static interface MergeStrategy {
        public Object merge(Map<String, Object> var1, OverAllState var2);
    }

    public static class DefaultMergeStrategy
    implements MergeStrategy {
        @Override
        public Object merge(Map<String, Object> subAgentResults, OverAllState overallState) {
            return new HashMap<String, Object>(subAgentResults);
        }
    }

    public static class ConcatenationMergeStrategy
    implements MergeStrategy {
        private final String separator;

        public ConcatenationMergeStrategy() {
            this("\n");
        }

        public ConcatenationMergeStrategy(String separator) {
            this.separator = separator;
        }

        @Override
        public Object merge(Map<String, Object> subAgentResults, OverAllState overallState) {
            return subAgentResults.values().stream().map(Object::toString).reduce("", (a, b) -> a.isEmpty() ? b : a + this.separator + b);
        }
    }

    public static class ListMergeStrategy
    implements MergeStrategy {
        @Override
        public Object merge(Map<String, Object> subAgentResults, OverAllState overallState) {
            return subAgentResults.values().stream().toList();
        }
    }
}

