/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.agent.MessageToolCallResultConverter;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.serializer.AgentInstructionMessage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.DefaultToolDefinition;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.execution.ToolCallResultConverter;
import org.springframework.ai.tool.method.MethodToolCallback;
import org.springframework.ai.tool.support.ToolDefinitions;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AgentTool {
    private static final ToolCallResultConverter CONVERTER = new MessageToolCallResultConverter();

    public static ToolCallback getFunctionToolCallback(ReactAgent agent) {
        return AgentTool.create(agent);
    }

    public static ToolCallback create(ReactAgent agent) {
        Method method = ReflectionUtils.findMethod(AgentToolExecutor.class, (String)"executeAgent", (Class[])new Class[]{String.class, ToolContext.class});
        if (method == null) {
            throw new IllegalStateException("Could not find executeAgent method in AgentToolExecutor class");
        }
        String originalSchema = StringUtils.hasLength((String)agent.getInputSchema()) ? agent.getInputSchema() : (agent.getInputType() != null ? JsonSchemaGenerator.generateForType((Type)agent.getInputType(), (JsonSchemaGenerator.SchemaOption[])new JsonSchemaGenerator.SchemaOption[0]) : null);
        DefaultToolDefinition.Builder builder = ToolDefinitions.builder((Method)method).name(agent.name()).description(agent.description());
        if (StringUtils.hasLength((String)originalSchema)) {
            String wrappedInputSchema = AgentTool.wrapSchemaInInputParameter(originalSchema);
            builder.inputSchema(wrappedInputSchema);
        }
        ToolDefinition toolDefinition = builder.build();
        AgentToolExecutor executor = new AgentToolExecutor(agent);
        return MethodToolCallback.builder().toolDefinition(toolDefinition).toolMethod(method).toolObject((Object)executor).toolCallResultConverter(CONVERTER).build();
    }

    private static String wrapSchemaInInputParameter(String originalSchema) {
        ObjectMapper objectMapper = JsonParser.getObjectMapper();
        try {
            Map originalSchemaMap = null;
            if (StringUtils.hasLength((String)originalSchema)) {
                try {
                    originalSchemaMap = (Map)objectMapper.readValue(originalSchema, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                }
                catch (Exception e) {
                    originalSchemaMap = Map.of("type", "string");
                }
            } else {
                originalSchemaMap = Map.of("type", "string");
            }
            HashMap<String, Object> wrappedSchema = new HashMap<String, Object>();
            wrappedSchema.put("type", "object");
            HashMap<String, Map> properties = new HashMap<String, Map>();
            properties.put("input", originalSchemaMap);
            wrappedSchema.put("properties", properties);
            wrappedSchema.put("required", List.of("input"));
            return objectMapper.writeValueAsString(wrappedSchema);
        }
        catch (Exception e) {
            return String.format("{\n\t\"type\": \"object\",\n\t\"properties\": {\n\t\t\"input\": {\n\t\t\t\"type\": \"string\"\n\t\t}\n\t},\n\t\"required\": [\"input\"]\n}\n", new Object[0]);
        }
    }

    public static class AgentToolExecutor {
        private final ReactAgent agent;

        public AgentToolExecutor(ReactAgent agent) {
            this.agent = agent;
        }

        public AssistantMessage executeAgent(String input, ToolContext toolContext) {
            String actualInput = this.extractInputValue(input);
            ArrayList<Object> messagesToAdd = new ArrayList<Object>();
            if (StringUtils.hasLength((String)this.agent.instruction())) {
                messagesToAdd.add(AgentInstructionMessage.builder().text(this.agent.instruction()).build());
            }
            messagesToAdd.add(new UserMessage(actualInput));
            Optional resultState = this.agent.getAndCompileGraph().invoke(Map.of("messages", messagesToAdd));
            Optional messages = resultState.flatMap(overAllState -> overAllState.value("messages", List.class));
            if (messages.isPresent()) {
                List messageList = (List)messages.get();
                return (AssistantMessage)messageList.get(messageList.size() - 1);
            }
            throw new RuntimeException("Failed to execute agent tool or failed to get agent tool result");
        }

        private String extractInputValue(String input) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            try {
                Object inputValue;
                ObjectMapper objectMapper = JsonParser.getObjectMapper();
                Map jsonMap = (Map)objectMapper.readValue(input, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                if (jsonMap != null && jsonMap.containsKey("input") && (inputValue = jsonMap.get("input")) != null) {
                    if (inputValue instanceof String) {
                        return (String)inputValue;
                    }
                    return JsonParser.getObjectMapper().writeValueAsString(inputValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return input;
        }
    }
}

