/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent.loop;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.agent.flow.agent.loop.LoopStrategy;
import java.util.Map;

public class CountLoopStrategy
implements LoopStrategy {
    private final int maxCount;

    public CountLoopStrategy(int maxCount) {
        this.maxCount = Math.min(maxCount, this.maxLoopCount());
    }

    @Override
    public Map<String, Object> loopInit(OverAllState state) {
        return Map.of(this.loopCountKey(), 0, this.loopFlagKey(), this.maxCount > 0);
    }

    @Override
    public Map<String, Object> loopDispatch(OverAllState state) {
        int count = (Integer)state.value(this.loopCountKey(), (Object)this.maxCount);
        if (count < this.maxCount) {
            return Map.of(this.loopCountKey(), count + 1, this.loopFlagKey(), true);
        }
        return Map.of(this.loopFlagKey(), false);
    }
}

