/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.meta;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class MetaUtil {
    public static List<String> getTables(DataSource ds) {
        return MetaUtil.getTables(ds, TableType.TABLE);
    }

    public static List<String> getTables(DataSource ds, TableType ... types) {
        return MetaUtil.getTables(ds, null, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        return MetaUtil.getTables(ds, schema, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        ResultSet rs;
        Connection conn;
        ArrayList<String> tables;
        block7: {
            DatabaseMetaData metaData;
            tables = new ArrayList<String>();
            conn = null;
            rs = null;
            conn = ds.getConnection();
            String catalog = MetaUtil.getCataLog(conn);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            if ((rs = (metaData = conn.getMetaData()).getTables(catalog, schema, tableName, Convert.toStrArray((Object)types))) != null) break block7;
            List<String> list = null;
            DbUtil.close(rs, conn);
            return list;
        }
        try {
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                tables.add(table);
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCataLog(conn);
            String schema = MetaUtil.getSchema(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            stringArray = columnNames.toArray(new String[columnNames.size()]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return Entity.create(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        Table table = Table.create(tableName);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCataLog(conn);
            String schema = MetaUtil.getSchema(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});
            if (rs.next()) {
                table.setComment(rs.getString("REMARKS"));
            }
            rs = metaData.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                table.addPk(rs.getString("COLUMN_NAME"));
            }
            rs = metaData.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                table.setColumn(Column.create(tableName, rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return table;
    }

    public static String getCataLog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

