/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.FtpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
implements Closeable {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private Charset charset;

    public Ftp(String host) {
        this(host, 21);
    }

    public Ftp(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public Ftp(String host, int port, String user, String password) {
        this(host, port, user, password, CharsetUtil.CHARSET_UTF_8);
    }

    public Ftp(String host, int port, String user, String password, Charset charset) {
        this.charset = charset;
        this.init(host, port, user, password);
    }

    public Ftp init(String host, int port, String user, String password) {
        FTPClient client = new FTPClient();
        client.setControlEncoding(this.charset.toString());
        try {
            client.connect(host, port);
            client.login(user, password);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", user, replyCode);
        }
        this.client = client;
        return this;
    }

    public boolean cd(String directory) {
        boolean flag = true;
        try {
            flag = this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return flag;
    }

    public boolean mkdir(String remote) {
        boolean success;
        block2: {
            success = true;
            String directory = StrUtil.addSuffixIfNot(remote, "/");
            if (directory.equalsIgnoreCase("/") || this.cd(directory)) break block2;
            int start = directory.startsWith(directory) ? 1 : 0;
            int end = directory.indexOf(directory.startsWith(directory) ? 1 : 0, start);
            String path = "";
            String paths = "";
            do {
                String subDirectory;
                if (!this.existFile(path = StrUtil.format((CharSequence)"{}/{}", path, subDirectory = remote.substring(start, end)))) {
                    this.makeDirectory(subDirectory);
                }
                this.cd(subDirectory);
                paths = StrUtil.format((CharSequence)"{}/{}", paths, subDirectory);
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }

    public boolean existFile(String path) {
        FTPFile[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return ArrayUtil.isNotEmpty(ftpFileArr);
    }

    public boolean del(String path, String fileName) {
        this.cd(path);
        try {
            return this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean upload(String path, File file) {
        Assert.notNull(file, "file to upload is null !", new Object[0]);
        return this.upload(path, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) {
        try (BufferedInputStream in = FileUtil.getInputStream(file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        this.mkdir(path);
        this.cd(path);
        try {
            return this.client.storeFile(fileName, fileStream);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtil.touch(outFile);
        }
        try (BufferedOutputStream out = FileUtil.getOutputStream(outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        this.cd(path);
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.client.logout();
        if (this.client.isConnected()) {
            this.client.disconnect();
        }
    }

    private boolean makeDirectory(String dir) {
        boolean flag = true;
        try {
            flag = this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return flag;
    }
}

