/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.dialect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.StaticLog;
import cn.hutool.setting.AbsSetting;
import cn.hutool.setting.SettingLoader;
import cn.hutool.setting.SettingRuntimeException;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BasicSetting
extends AbsSetting
implements Map<Object, Object> {
    private static final long serialVersionUID = 3618305164959883393L;
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final List<String> groups = new ArrayList<String>();
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
    protected Charset charset;
    protected boolean isUseVariable;
    protected URL settingUrl;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public BasicSetting() {
    }

    public BasicSetting(String path) {
        this(path, DEFAULT_CHARSET, false);
    }

    public BasicSetting(String path, Charset charset, boolean isUseVariable) {
        Assert.notBlank(path, "Blank setting path !", new Object[0]);
        this.init(ResourceUtil.getResourceObj(path), charset, isUseVariable);
    }

    public BasicSetting(File configFile, Charset charset, boolean isUseVariable) {
        Assert.notNull(configFile, "Null setting file define!", new Object[0]);
        this.init(new FileResource(configFile), charset, isUseVariable);
    }

    public BasicSetting(String path, Class<?> clazz, Charset charset, boolean isUseVariable) {
        Assert.notBlank(path, "Blank setting path !", new Object[0]);
        this.init(new ClassPathResource(path, clazz), charset, isUseVariable);
    }

    public BasicSetting(URL url, Charset charset, boolean isUseVariable) {
        Assert.notNull(url, "Null setting url define!", new Object[0]);
        this.init(new UrlResource(url), charset, isUseVariable);
    }

    public boolean init(Resource resource, Charset charset, boolean isUseVariable) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        this.settingUrl = resource.getUrl();
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(new UrlResource(this.settingUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            try {
                this.watchMonitor = WatchMonitor.create(this.settingUrl, StandardWatchEventKinds.ENTRY_MODIFY);
                this.watchMonitor.setWatcher(new SimpleWatcher(){

                    @Override
                    public void onModify(WatchEvent<?> event, Path currentPath) {
                        BasicSetting.this.load();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new SettingRuntimeException(e, "Setting auto load not support url: [{}]", this.settingUrl);
            }
            StaticLog.debug("Auto load for [{}] listenning...", this.settingUrl);
        } else {
            IoUtil.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public String getSettingPath() {
        return null == this.settingUrl ? null : this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object value = this.map.get(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public Object getAndRemove(String ... keys) {
        String key;
        Object value = null;
        String[] arr$ = keys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && null == (value = this.remove(key = arr$[i$])); ++i$) {
        }
        return value;
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] arr$ = keys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && null == (value = this.remove(key = arr$[i$])); ++i$) {
        }
        return (String)value;
    }

    public Map<?, ?> getMap(String group) {
        if (StrUtil.isBlank(group)) {
            return this;
        }
        String groupDot = group.concat(".");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (Object key : this.map.keySet()) {
            String keyStr = Convert.toStr(key);
            if (!StrUtil.isNotBlank(keyStr) || !keyStr.startsWith(groupDot)) continue;
            map2.put(StrUtil.removePrefix(keyStr, groupDot), this.map.get(key));
        }
        return map2;
    }

    public BasicSetting getSetting(String group) {
        BasicSetting setting = new BasicSetting();
        setting.putAll((Map<? extends Object, ? extends Object>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public void store(String absolutePath) {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        this.settingLoader.store(absolutePath);
    }

    public void setVarRegex(String regex) {
        if (null == this.settingLoader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex(regex);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.map);
        return properties;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public BasicSetting set(String key, String group, Object value) {
        if (StrUtil.isNotBlank(group) && !this.groups.contains(group = group.trim())) {
            this.groups.add(group);
        }
        this.put(BasicSetting.keyWithGroup(key, group), value);
        return this;
    }

    public BasicSetting set(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        this.map.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.groups.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + (this.isUseVariable ? 1231 : 1237);
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.settingUrl == null ? 0 : this.settingUrl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSetting other = (BasicSetting)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return !(this.settingUrl == null ? other.settingUrl != null : !this.settingUrl.equals(other.settingUrl));
    }
}

