/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.StrUtil;

public class NumberChineseFormater {
    private static final String[] simpleDigits = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] traditionalDigits = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] simpleUnits = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] traditionalUnits = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChineseFormater.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        String[] numArray;
        String[] stringArray = numArray = isUseTraditional ? traditionalDigits : simpleDigits;
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        String chineseStr = "";
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumberChineseFormater.toChinese(parts[i2], isUseTraditional);
            if (i2 % 2 == 0) {
                beforeWanIsZero = StrUtil.isEmpty(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr = "\u4ebf" + chineseStr;
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr = "\u96f6" + chineseStr;
                    }
                    chineseStr = "\u4e07" + chineseStr;
                }
            }
            chineseStr = partChinese + chineseStr;
        }
        if ("".equals(chineseStr)) {
            chineseStr = numArray[0];
        } else if (negative) {
            chineseStr = "\u8d1f" + chineseStr;
        }
        if (numFen != 0 || numJiao != 0) {
            chineseStr = numFen == 0 ? chineseStr + (isMoneyMode ? "\u5143" : "\u70b9") + numArray[numJiao] + (isMoneyMode ? "\u89d2" : "") : (numJiao == 0 ? chineseStr + (isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6") + numArray[numFen] + (isMoneyMode ? "\u5206" : "") : chineseStr + (isMoneyMode ? "\u5143" : "\u70b9") + numArray[numJiao] + (isMoneyMode ? "\u89d2" : "") + numArray[numFen] + (isMoneyMode ? "\u5206" : ""));
        } else if (isMoneyMode) {
            chineseStr = chineseStr + "\u6574";
        }
        return chineseStr;
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? traditionalDigits : simpleDigits;
        String[] units = isUseTraditional ? traditionalUnits : simpleUnits;
        int temp = amountPart;
        String chineseStr = "";
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0 && temp != 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
            } else {
                chineseStr = numArray[digit] + units[i] + chineseStr;
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr;
    }
}

