/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Object getFieldValue(Class<?> targetClass, String fieldName, Object targetObj) {
        Field field = ReflectionUtil.getField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return null;
        }
        Object fieldObj = ReflectionUtils.getField((Field)field, (Object)targetObj);
        if (Objects.isNull(fieldObj)) {
            return null;
        }
        return fieldObj;
    }

    public static void setFieldValue(Class<?> targetClass, String fieldName, Object targetObj, Object targetVal) throws IllegalAccessException {
        Field field = ReflectionUtil.getField(targetClass, fieldName);
        if (Objects.isNull(field)) {
            return;
        }
        field.set(targetObj, targetVal);
    }

    public static Field getField(Class<?> targetClass, String fieldName) {
        Field field = ReflectionUtils.findField(targetClass, (String)fieldName);
        if (Objects.isNull(field)) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }
}

