/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.queue;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MemoryLimitCalculator {
    private static volatile long maxAvailable;
    private static final ScheduledExecutorService SCHEDULER;

    private static void refresh() {
        maxAvailable = Runtime.getRuntime().freeMemory();
    }

    public static long maxAvailable() {
        return maxAvailable;
    }

    static {
        SCHEDULER = Executors.newSingleThreadScheduledExecutor();
        MemoryLimitCalculator.refresh();
        SCHEDULER.scheduleWithFixedDelay(MemoryLimitCalculator::refresh, 50L, 50L, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(SCHEDULER::shutdown));
    }
}

