/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.entity;

import com.dtp.common.em.NotifyItemEnum;
import com.dtp.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class NotifyItem {
    private List<String> platforms;
    private boolean enabled = true;
    private String type;
    private int threshold;
    private int interval = 120;
    private int clusterLimit = 1;

    public static List<NotifyItem> mergeSimpleNotifyItems(List<NotifyItem> source) {
        if (CollectionUtils.isEmpty(source)) {
            return NotifyItem.getSimpleNotifyItems();
        }
        List configuredTypes = source.stream().map(NotifyItem::getType).collect(Collectors.toList());
        List defaultItems = NotifyItem.getSimpleNotifyItems().stream().filter(t -> !StringUtil.containsIgnoreCase((CharSequence)t.getType(), configuredTypes)).collect(Collectors.toList());
        source.addAll(defaultItems);
        return source;
    }

    public static List<NotifyItem> getSimpleNotifyItems() {
        NotifyItem changeNotify = new NotifyItem();
        changeNotify.setType(NotifyItemEnum.CHANGE.getValue());
        changeNotify.setInterval(1);
        NotifyItem livenessNotify = new NotifyItem();
        livenessNotify.setType(NotifyItemEnum.LIVENESS.getValue());
        livenessNotify.setThreshold(70);
        NotifyItem capacityNotify = new NotifyItem();
        capacityNotify.setType(NotifyItemEnum.CAPACITY.getValue());
        capacityNotify.setThreshold(70);
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(3);
        notifyItems.add(livenessNotify);
        notifyItems.add(changeNotify);
        notifyItems.add(capacityNotify);
        return notifyItems;
    }

    public static List<NotifyItem> mergeAllNotifyItems(List<NotifyItem> source) {
        if (CollectionUtils.isEmpty(source)) {
            return NotifyItem.getAllNotifyItems();
        }
        List configuredTypes = source.stream().map(NotifyItem::getType).collect(Collectors.toList());
        List defaultItems = NotifyItem.getAllNotifyItems().stream().filter(t -> !StringUtil.containsIgnoreCase((CharSequence)t.getType(), configuredTypes)).collect(Collectors.toList());
        source.addAll(defaultItems);
        return source;
    }

    public static List<NotifyItem> getAllNotifyItems() {
        NotifyItem rejectNotify = new NotifyItem();
        rejectNotify.setType(NotifyItemEnum.REJECT.getValue());
        rejectNotify.setThreshold(1);
        NotifyItem runTimeoutNotify = new NotifyItem();
        runTimeoutNotify.setType(NotifyItemEnum.RUN_TIMEOUT.getValue());
        runTimeoutNotify.setThreshold(1);
        NotifyItem queueTimeoutNotify = new NotifyItem();
        queueTimeoutNotify.setType(NotifyItemEnum.QUEUE_TIMEOUT.getValue());
        queueTimeoutNotify.setThreshold(1);
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(6);
        notifyItems.addAll(NotifyItem.getSimpleNotifyItems());
        notifyItems.add(rejectNotify);
        notifyItems.add(runTimeoutNotify);
        notifyItems.add(queueTimeoutNotify);
        return notifyItems;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getType() {
        return this.type;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getClusterLimit() {
        return this.clusterLimit;
    }

    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setClusterLimit(int clusterLimit) {
        this.clusterLimit = clusterLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyItem)) {
            return false;
        }
        NotifyItem other = (NotifyItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        if (this.getClusterLimit() != other.getClusterLimit()) {
            return false;
        }
        List<String> this$platforms = this.getPlatforms();
        List<String> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifyItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getThreshold();
        result = result * 59 + this.getInterval();
        result = result * 59 + this.getClusterLimit();
        List<String> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "NotifyItem(platforms=" + this.getPlatforms() + ", enabled=" + this.isEnabled() + ", type=" + this.getType() + ", threshold=" + this.getThreshold() + ", interval=" + this.getInterval() + ", clusterLimit=" + this.getClusterLimit() + ")";
    }
}

