/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository;

import cn.dalgen.mybatis.gen.enums.MultiplicityEnum;
import cn.dalgen.mybatis.gen.enums.PagingCntTypeEnum;
import cn.dalgen.mybatis.gen.enums.ParamTypeEnum;
import cn.dalgen.mybatis.gen.exception.DalgenException;
import cn.dalgen.mybatis.gen.model.config.CfAssociation;
import cn.dalgen.mybatis.gen.model.config.CfCollection;
import cn.dalgen.mybatis.gen.model.config.CfColumn;
import cn.dalgen.mybatis.gen.model.config.CfOperation;
import cn.dalgen.mybatis.gen.model.config.CfResultMap;
import cn.dalgen.mybatis.gen.model.config.CfTable;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class CfTableRepository {
    private static final Pattern PARAM_PATTERN = Pattern.compile("#\\{(.*?)\\}");
    private static final Pattern STAR_BRACKET = Pattern.compile("\\((\\s*\\*\\s*)\\)");
    private static final Pattern QUESTION_MARK_PATTERN = Pattern.compile("\\w+\\s*=\\s*\\?");
    private static final String JAVA_TYPE = "javatype\\s*=\\s*\".*?\"";
    private static final Pattern QUESTION_COLUMN_PATTERN = Pattern.compile("\\w{1,}");
    private static final String FOR_DESC_SQL_P = "\\s*<.*>\\s*";
    private static final String FOR_DESC_SQL_PN = "\\s{2,}";
    private static final String COUNT_X = "count\\(\\s*\\*\\s*\\)";
    private static final String ORDER_BY_PATTERN = "[o|O][r|R][d|D][e|E][r|R]\\s+[b|B][y|Y]\\s+";
    private static final Pattern SELECT_FROM_PATTERN = Pattern.compile("[s|S][e|E][l|L][e|E][c|C][t|T]\\s+[\\s\\S]*?\\s+[f|F][r|R][o|O][m|M]");
    private static final String REPLACE_TMP = " ( \u2299 o \u2299 ) ";

    public CfTable gainCfTable(DefaultElement table, Map<String, Element> cfSqlMap) throws DocumentException {
        CfTable cfTable = new CfTable();
        cfTable.setSqlname(this.attr((Element)table, "sqlname"));
        cfTable.setPhysicalName(this.attr((Element)table, "physicalName"));
        cfTable.setRemark(this.attr((Element)table, "remark"));
        cfTable.setSequence(this.attr((Element)table, "sequence"));
        cfTable.setOrdinalEffectiveDay(this.attr((Element)table, "ordinalEffectiveDay"));
        cfTable.setOrdinalMaxPosition(this.attrLong((Element)table, "ordinalMaxPosition"));
        this.fillColumns(cfTable, (Element)table);
        this.fillResultMap(cfTable, (Element)table);
        this.fillOperation(cfTable, table, cfSqlMap);
        this.fillSql(cfTable, table);
        return cfTable;
    }

    private void fillSql(CfTable cfTable, DefaultElement table) {
        List elements = table.elements("sql");
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            for (Element element : elements) {
                cfTable.addSqlMap(element.attributeValue("id"), element.asXML());
            }
        }
    }

    private void fillResultMap(CfTable cfTable, Element table) {
        List elements = table.elements("resultmap");
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            for (Element e : elements) {
                CfResultMap cfResultMap = new CfResultMap();
                cfResultMap.setName(this.attr(e, "name"));
                cfResultMap.setType(this.attr(e, "type"));
                cfResultMap.setRemark(this.attr(e, "remark"));
                String extend = this.attr(e, "extend");
                if (StringUtils.isNotBlank((String)extend)) {
                    cfResultMap.setExtend(extend);
                }
                List ers = e.elements();
                for (Element er : ers) {
                    if (StringUtils.equals((String)er.getName(), (String)"column")) {
                        CfColumn cfColumn = new CfColumn();
                        cfColumn.setName(this.attr(er, "name"));
                        cfColumn.setJavatype(this.attr(er, "javatype"));
                        cfColumn.setSqlType(this.attr(er, "jdbctype"));
                        cfColumn.setRemark(this.attr(er, "remark"));
                        cfColumn.setRelatedColumn(this.attr(er, "relatedColumn"));
                        cfResultMap.addColumn(cfColumn);
                        continue;
                    }
                    if (StringUtils.equals((String)er.getName(), (String)"association")) {
                        CfAssociation cfAssociation = new CfAssociation();
                        cfAssociation.setColumn(this.attr(er, "column"));
                        cfAssociation.setProperty(this.attr(er, "property"));
                        cfAssociation.setSelect(this.attr(er, "select"));
                        cfAssociation.setRemark(this.attr(er, "remark"));
                        cfResultMap.addAssociation(cfAssociation);
                        continue;
                    }
                    if (StringUtils.equals((String)er.getName(), (String)"collection")) {
                        CfCollection cfCollection = new CfCollection();
                        cfCollection.setColumn(this.attr(er, "column"));
                        cfCollection.setProperty(this.attr(er, "property"));
                        cfCollection.setSelect(this.attr(er, "select"));
                        cfCollection.setRemark(this.attr(er, "remark"));
                        cfResultMap.addCollection(cfCollection);
                        continue;
                    }
                    if (!StringUtils.equals((String)er.getName(), (String)"import")) continue;
                    cfResultMap.assImport(this.attr(er, "class"));
                }
                cfTable.addResultMap(cfResultMap);
            }
        }
    }

    private void fillOperation(CfTable cfTable, DefaultElement table, Map<String, Element> cfSqlMap) {
        List operations = table.elements("operation");
        for (Element operation : operations) {
            CfOperation cfOperation = new CfOperation();
            cfOperation.setRemark(this.attr(operation, "remark"));
            cfOperation.setName(this.attr(operation, "name"));
            cfOperation.setMultiplicity(MultiplicityEnum.getByCode(this.attr(operation, "multiplicity")));
            cfOperation.setPagingCntType(PagingCntTypeEnum.getByCode(this.attr(operation, "pagingCntType")));
            cfOperation.setPaging(this.attr(operation, "paging"));
            cfOperation.setPagingCntOperation(this.attr(operation, "pagingCntOperation"));
            if (cfOperation.getMultiplicity() == MultiplicityEnum.paging) {
                Validate.notEmpty((String)cfOperation.getPaging(), (String)"\u9700\u8981\u8bbe\u7f6epaging,\u7528\u6765\u751f\u6210\u5206\u9875\u7c7b");
            }
            if (cfOperation.getPagingCntType() == PagingCntTypeEnum.pagingCustom) {
                Validate.notEmpty((String)cfOperation.getPagingCntOperation(), (String)"\u9700\u8981\u8bbe\u7f6epagingCntSql,\u83b7\u53d6\u5206\u9875Operation");
                Validate.notEmpty((String)cfOperation.getPaging(), (String)"\u9700\u8981\u8bbe\u7f6epaging,\u7528\u6765\u751f\u6210\u5206\u9875\u7c7b");
            }
            cfOperation.setParamType(ParamTypeEnum.getByCode(this.attr(operation, "paramtype")));
            cfOperation.setResultmap(this.attr(operation, "resultmap"));
            cfOperation.setResulttype(this.attr(operation, "resulttype"));
            cfOperation.setKvMap(this.attr(operation, "kvmap"));
            cfOperation.setMapK(this.attr(operation, "mapK"));
            cfOperation.setMapV(this.attr(operation, "mapV"));
            if (!StringUtils.equals((String)cfOperation.getKvMap(), (String)"false")) {
                Validate.isTrue((cfOperation.getMultiplicity() == MultiplicityEnum.many ? 1 : 0) != 0, (String)"\u8f6cKvMap\u8981\u6c42\u8fd4\u56de\u7ed3\u679c\u5fc5\u987b\u662fmany");
                Validate.isTrue((boolean)StringUtils.isNotBlank((String)cfOperation.getMapK()), (String)"\u8f6cKvMap\u8981\u6c42\u5fc5\u586bmapK");
            }
            this.setCfOperationCdata(cfTable, operation, table, cfOperation, cfSqlMap);
            cfTable.addOperation(cfOperation);
        }
    }

    private void setCfOperationCdata(CfTable cfTable, Element oElement, DefaultElement table, CfOperation cfOperation, Map<String, Element> cfSqlMap) {
        Element extraparams = oElement.element("extraparams");
        oElement.remove(extraparams);
        List optimizePagings = oElement.elements("optimizePaging");
        String cXml = oElement.asXML();
        String[] lines = StringUtils.split((String)cXml, (String)"\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < lines.length - 1; ++i) {
            if (i > 1) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        String cdata = sb.toString();
        String sqlDesc = cdata.replaceAll(FOR_DESC_SQL_P, " ");
        sqlDesc = sqlDesc.replaceAll(FOR_DESC_SQL_PN, " ");
        cfOperation.setSqlDesc(sqlDesc);
        String text = oElement.getTextTrim();
        if (StringUtils.indexOf((String)text, (String)"*") > 0) {
            cdata = StringUtils.replace((String)cdata, (String)"sf.*", (String)"<include refid=\"Base_SF_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"SF.*", (String)"<include refid=\"Base_SF_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"sF.*", (String)"<include refid=\"Base_SF_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"Sf.*", (String)"<include refid=\"Base_SF_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)".*", (String)"\u2014-dotStar--");
            cdata = StringUtils.replace((String)cdata, (String)"/*", (String)"--/Star--");
            cdata = StringUtils.replace((String)cdata, (String)"*/", (String)"--Star/--");
            cdata = cdata.replaceAll(COUNT_X, "count(!!!COUNT!!!)");
            cdata = StringUtils.replace((String)cdata, (String)" *", (String)" <include refid=\"Base_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"    *", (String)"   <include refid=\"Base_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"\n*", (String)"\n<include refid=\"Base_Column_List\" />");
            cdata = StringUtils.replace((String)cdata, (String)"\u2014-dotStar--", (String)".*");
            cdata = StringUtils.replace((String)cdata, (String)"--/Star--", (String)"/*");
            cdata = StringUtils.replace((String)cdata, (String)"--Star/--", (String)"*/");
            cdata = cdata.replaceAll("count\\(!!!COUNT!!!\\)", " count(*) ");
        }
        cdata = cdata.replaceAll(JAVA_TYPE, " ");
        this.setCfOperationPageCdata(cdata, cfOperation, optimizePagings);
        if (cfOperation.getMultiplicity() == MultiplicityEnum.paging) {
            if (cfOperation.getPagingCntType() == PagingCntTypeEnum.pagingCustom) {
                int indexOf = cdata.indexOf("{pageLimit}");
                Validate.isTrue((indexOf > 0 ? 1 : 0) != 0, (String)"pagingCustom \u9700\u8981\u4f7f\u7528 {pageLimit} \u6307\u5b9a\u5206\u9875");
                cdata = cdata.replace("{pageLimit}", "limit #{startRow},#{limit}");
            }
            if (cfOperation.getPagingCntType() == PagingCntTypeEnum.optimize) {
                cdata = cdata.replaceAll("<optimizePaging>", "");
                cdata = cdata.replaceAll("</optimizePaging>", " limit #{startRow},#{limit} ");
            }
        }
        cdata = this.delQuestionMarkParam(cdata, cfOperation, cfTable);
        cfOperation.setCdata(this.addSqlAnnotation(cdata, cfOperation.getName(), cfTable.getSqlname()));
        this.dalExtraparams(extraparams, cfOperation);
        this.fillOperationParams(oElement, table, cfOperation, cfSqlMap);
    }

    private void setCfOperationPageCdata(String cdata, CfOperation cfOperation, List<Element> optimizePagings) {
        String forCount = cdata;
        if (cfOperation.getMultiplicity() == MultiplicityEnum.paging && cfOperation.getPagingCntType() != PagingCntTypeEnum.pagingCustom) {
            String cdataCount = null;
            if (cfOperation.getPagingCntType() == PagingCntTypeEnum.paging) {
                int indexof;
                Matcher selectFromMather = SELECT_FROM_PATTERN.matcher(forCount);
                if (selectFromMather.find()) {
                    forCount = selectFromMather.replaceFirst("SELECT\n          COUNT(*) AS total \n        FROM\n");
                }
                if ((indexof = (cdataCount = forCount.replaceAll(ORDER_BY_PATTERN, REPLACE_TMP)).indexOf(REPLACE_TMP)) > 0) {
                    cdataCount = cdataCount.substring(0, indexof).replaceAll("(?m)^\\s*$" + System.lineSeparator(), "");
                }
                Validate.notEmpty((String)cdataCount, (String)"\u5206\u9875cdataCount\u5904\u7406\u5f02\u5e38");
            } else if (cfOperation.getPagingCntType() == PagingCntTypeEnum.optimize) {
                int indexof;
                Validate.notEmpty(optimizePagings, (String)"optimize \u6a21\u5f0f\u5fc5\u987b\u914d\u7f6e <optimizePagings>");
                forCount = optimizePagings.get(0).asXML();
                Matcher selectFromMather = SELECT_FROM_PATTERN.matcher(forCount);
                if (selectFromMather.find()) {
                    forCount = selectFromMather.replaceFirst("SELECT\n          COUNT(*) AS total \n        FROM\n");
                }
                if ((indexof = (cdataCount = forCount.replaceAll(ORDER_BY_PATTERN, REPLACE_TMP)).indexOf(REPLACE_TMP)) > 0) {
                    cdataCount = cdataCount.substring(0, indexof).replaceAll("(?m)^\\s*$" + System.lineSeparator(), "");
                }
                cdataCount = cdataCount.replaceAll("<optimizePaging>", "");
                cdataCount = cdataCount.replaceAll("</optimizePaging>", "");
                Validate.notEmpty((String)cdataCount, (String)"\u5206\u9875cdataCount\u5904\u7406\u5f02\u5e38");
            } else if (cfOperation.getPagingCntType() == PagingCntTypeEnum.pagingExtCnt) {
                cdataCount = forCount.replaceAll(ORDER_BY_PATTERN, REPLACE_TMP);
                int indexof = cdataCount.indexOf(REPLACE_TMP);
                if (indexof > 0) {
                    cdataCount = cdataCount.substring(0, indexof).replaceAll("(?m)^\\s*$" + System.lineSeparator(), "");
                }
                Validate.notEmpty((String)cdataCount, (String)"\u5206\u9875cdataCount\u5904\u7406\u5f02\u5e38");
                cdataCount = "        SELECT\n          COUNT(*) AS total \n        FROM(" + cdataCount + ") as tmp";
            }
            cfOperation.setCdataPageCount(cdataCount);
        }
    }

    private void dalExtraparams(Element extraparams, CfOperation cfOperation) {
        List params;
        if (extraparams != null && CollectionUtils.isNotEmpty((Collection)(params = extraparams.elements()))) {
            for (Element param : params) {
                String name = this.attr(param, "name");
                cfOperation.addPrimitiveParam(name, this.attr(param, "javatype"));
                String testVal = this.attr(param, "testVal");
                if (!StringUtils.isNotBlank((String)testVal)) continue;
                cfOperation.addPrimitiveParamTestVal(name, testVal);
            }
        }
    }

    private String delQuestionMarkParam(String cdata, CfOperation cfOperation, CfTable cfTable) {
        if (!StringUtils.contains((String)cdata, (char)'?')) {
            return cdata;
        }
        cfTable.getColumns();
        if (StringUtils.startsWithIgnoreCase((String)cfOperation.getName(), (String)"insert")) {
            String sql = cdata;
            sql = sql.replaceAll("\\s{1,}", "");
            sql = sql.replaceAll("\\(\\)", "");
            sql = sql.replaceAll("\\(", "\n(\n");
            sql = sql.replaceAll("\\)", "\n)\n");
            String[] sqlLines = StringUtils.split((String)sql, (String)"\n");
            int i = 0;
            for (String sqlLine : sqlLines) {
                if (StringUtils.startsWith((String)sqlLine, (String)"(")) break;
                ++i;
            }
            String insertLine = sqlLines[i + 1];
            String valueLine = sqlLines[i + 5];
            valueLine = valueLine.replaceAll("\\w{1},\\w{1}", "");
            String[] columns = StringUtils.split((String)insertLine, (char)',');
            String[] params = StringUtils.split((String)valueLine, (char)',');
            for (int j = 0; j < params.length; ++j) {
                if (!StringUtils.equals((String)params[j], (String)"?")) continue;
                try {
                    String columnParam = CamelCaseUtils.toCamelCase(columns[j]);
                    cdata = StringUtils.replace((String)cdata, (String)"?", (String)("#{" + columnParam + "}"), (int)1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DalgenException("\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef#{}\u4e2d,\u672a\u6b63\u786e\u4f7f\u7528 table=" + cfTable.getSqlname());
                }
            }
        } else {
            Matcher questionMarkPatternResult = QUESTION_MARK_PATTERN.matcher(cdata);
            while (questionMarkPatternResult.find()) {
                Matcher columnMatcher = QUESTION_COLUMN_PATTERN.matcher(questionMarkPatternResult.group());
                while (columnMatcher.find()) {
                    String columnParam = CamelCaseUtils.toCamelCase(columnMatcher.group());
                    cdata = StringUtils.replace((String)cdata, (String)"?", (String)("#{" + columnParam + "}"), (int)1);
                    cfOperation.addPrimitiveParam(columnParam, "");
                }
            }
        }
        return cdata;
    }

    private String addSqlAnnotation(String cdata, String oName, String tbName) {
        String sqlAnnotation = StringUtils.upperCase((String)CamelCaseUtils.toInlineName(CamelCaseUtils.toCamelCase("ms_" + tbName + "_" + oName)));
        if (StringUtils.startsWithIgnoreCase((String)oName, (String)"insert ") || StringUtils.startsWithIgnoreCase((String)oName, (String)"update") || StringUtils.startsWithIgnoreCase((String)oName, (String)"delete")) {
            if (StringUtils.contains((String)cdata, (String)"update ")) {
                return StringUtils.replace((String)cdata, (String)"update ", (String)("update /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"UPDATE ")) {
                return StringUtils.replace((String)cdata, (String)"UPDATE ", (String)("UPDATE /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"insert ")) {
                return StringUtils.replace((String)cdata, (String)"insert ", (String)("insert /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"INSERT ")) {
                return StringUtils.replace((String)cdata, (String)"INSERT ", (String)("INSERT /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"delete ")) {
                return StringUtils.replace((String)cdata, (String)"delete ", (String)("delete /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"DELETE ")) {
                return StringUtils.replace((String)cdata, (String)"DELETE ", (String)("DELETE /*" + sqlAnnotation + "*/ "));
            }
        } else {
            if (StringUtils.contains((String)cdata, (String)"select ")) {
                return StringUtils.replace((String)cdata, (String)"select ", (String)("select /*" + sqlAnnotation + "*/ "));
            }
            if (StringUtils.contains((String)cdata, (String)"SELECT ")) {
                return StringUtils.replace((String)cdata, (String)"SELECT", (String)("SELECT /*" + sqlAnnotation + "*/ "));
            }
        }
        return cdata;
    }

    private void fillOperationParams(Element e, DefaultElement table, CfOperation cfOperation, Map<String, Element> cfSqlMap) {
        if (cfOperation.getParamType() != ParamTypeEnum.primitive) {
            return;
        }
        List items = e.elements();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (DefaultElement item : items) {
                List ies = item.elements();
                if (StringUtils.endsWithIgnoreCase((String)"include", (String)item.getName())) {
                    DefaultElement includeElement = this.elementById((Element)table, item.attributeValue("refid"));
                    if (includeElement == null) {
                        includeElement = cfSqlMap.get(item.attributeValue("refid"));
                    }
                    Validate.notNull((Object)includeElement, (String)("include refid=" + item.attributeValue("refid") + " \u5bf9\u5e94\u7684SQL \u672a\u914d\u7f6e"));
                    this.fillOperationParams((Element)includeElement, table, cfOperation, cfSqlMap);
                    continue;
                }
                if (CollectionUtils.isNotEmpty((Collection)ies)) {
                    this.recursiveForeachElement(cfOperation, table, ies, cfSqlMap);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((String)item.getName(), (String)"foreach")) continue;
                String collName = item.attributeValue("collection");
                String itemName = item.attributeValue("item");
                Validate.notEmpty((String)collName, (String)("foreach \u5143\u7d20\u8bbe\u7f6e\u9519\u8bef table=" + cfOperation.getName()));
                Validate.notEmpty((String)itemName, (String)("foreach \u5143\u7d20\u8bbe\u7f6e\u9519\u8bef table=" + cfOperation.getName()));
                String javatype = item.attributeValue("javatype");
                if (StringUtils.isNotBlank((String)javatype)) {
                    cfOperation.addPrimitiveForeachOtherParam("list_" + itemName, collName, javatype);
                    continue;
                }
                cfOperation.addPrimitiveForeachParam(itemName, collName);
            }
        }
        Matcher m = PARAM_PATTERN.matcher(e.asXML());
        ArrayList params = Lists.newArrayList();
        while (m.find()) {
            params.add(m.group(1));
        }
        for (String _p : params) {
            String p = _p.replaceAll(" ", "");
            String attr = null;
            String type = null;
            for (String s : StringUtils.split((String)p, (String)",")) {
                if (s.contains("=")) {
                    if (!StringUtils.startsWithIgnoreCase((String)s, (String)"javaType") && !StringUtils.startsWithIgnoreCase((String)s, (String)"jdbcType")) continue;
                    type = StringUtils.split((String)s, (String)"=")[1].trim();
                    continue;
                }
                attr = StringUtils.trim((String)s);
            }
            cfOperation.addPrimitiveParam(attr, type);
        }
    }

    private void recursiveForeachElement(CfOperation cfOperation, DefaultElement table, List<Element> ies, Map<String, Element> cfSqlMap) {
        for (Element ie : ies) {
            if (StringUtils.endsWithIgnoreCase((String)"include", (String)ie.getName())) {
                DefaultElement includeElement = this.elementById((Element)table, ie.attributeValue("refid"));
                if (includeElement == null) {
                    includeElement = cfSqlMap.get(ie.attributeValue("refid"));
                }
                Validate.notNull((Object)includeElement, (String)("include refid=" + ie.attributeValue("refid") + " \u5bf9\u5e94\u7684SQL \u672a\u914d\u7f6e"));
                this.fillOperationParams((Element)includeElement, table, cfOperation, cfSqlMap);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)ie.getName(), (String)"foreach")) {
                List _ies;
                String collName = ie.attributeValue("collection");
                String itemName = ie.attributeValue("item");
                Validate.notEmpty((String)collName, (String)("foreach \u5143\u7d20\u8bbe\u7f6e\u9519\u8bef table=" + cfOperation.getName()));
                Validate.notEmpty((String)itemName, (String)("foreach \u5143\u7d20\u8bbe\u7f6e\u9519\u8bef table=" + cfOperation.getName()));
                String javatype = ie.attributeValue("javatype");
                if (StringUtils.isNotBlank((String)javatype)) {
                    cfOperation.addPrimitiveForeachOtherParam("list_" + itemName, collName, javatype);
                } else {
                    cfOperation.addPrimitiveForeachParam(itemName, collName);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(_ies = ie.elements()))) continue;
                this.recursiveForeachElement(cfOperation, table, _ies, cfSqlMap);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)ie.elements())) continue;
            this.recursiveForeachElement(cfOperation, table, ie.elements(), cfSqlMap);
        }
    }

    private void fillColumns(CfTable cfTable, Element table) {
        List elements = table.elements("column");
        for (Element e : elements) {
            CfColumn cfColumn = new CfColumn();
            cfColumn.setName(this.attr(e, "name"));
            cfColumn.setJavatype(this.attr(e, "javatype"));
            cfColumn.setTestVal(this.attr(e, "testVal"));
            cfColumn.setTypeHandler(this.attr(e, "typeHandler"));
            cfColumn.setRelatedColumn(this.attr(e, "relatedColumn"));
            cfTable.addColumn(cfColumn);
        }
    }

    private String attr(Element e, String attr) {
        if (e == null || attr == null) {
            return null;
        }
        Attribute attribute = e.attribute(attr);
        if (attribute == null) {
            return null;
        }
        return attribute.getText();
    }

    private Long attrLong(Element e, String attr) {
        if (e == null || attr == null) {
            return null;
        }
        Attribute attribute = e.attribute(attr);
        if (attribute == null) {
            return null;
        }
        return Long.valueOf(attribute.getText());
    }

    private boolean attrBoolean(Element e, String attr) {
        if (e == null || attr == null) {
            return false;
        }
        Attribute attribute = e.attribute(attr);
        if (attribute == null) {
            return false;
        }
        return Boolean.valueOf(attribute.getText());
    }

    private DefaultElement elementById(Element element, String id) {
        List elements = element.elements();
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            for (DefaultElement element1 : elements) {
                DefaultElement defaultElement;
                if (StringUtils.equals((String)element1.attributeValue("id"), (String)id)) {
                    return element1;
                }
                if (!CollectionUtils.isNotEmpty((Collection)element1.elements()) || (defaultElement = this.elementById((Element)element1, id)) == null) continue;
                return defaultElement;
            }
        }
        return null;
    }
}

