/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports;

import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.sax.SaxReadCellEntity;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelDataHandler;
import cn.afterturn.easypoi.handler.inter.IExcelDictHandler;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueService.class);
    private List<String> handlerList = null;

    private Object getCellValue(String classFullName, Cell cell, ExcelImportEntity entity) {
        if (cell == null) {
            return "";
        }
        Object result = null;
        if ("class java.util.Date".equals(classFullName) || "class java.sql.Date".equals(classFullName) || "class java.sql.Time".equals(classFullName) || "class java.sql.Timestamp".equals(classFullName)) {
            if (CellType.NUMERIC == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
                result = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            } else {
                cell.setCellType(CellType.STRING);
                result = this.getDateData(entity, cell.getStringCellValue());
            }
            if ("class java.sql.Date".equals(classFullName)) {
                result = new Date(((java.util.Date)result).getTime());
            }
            if ("class java.sql.Time".equals(classFullName)) {
                result = new Time(((java.util.Date)result).getTime());
            }
            if ("class java.sql.Timestamp".equals(classFullName)) {
                result = new Timestamp(((java.util.Date)result).getTime());
            }
        } else if (CellType.NUMERIC == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
            result = DateUtil.getJavaDate((double)cell.getNumericCellValue());
        } else {
            switch (cell.getCellType()) {
                case STRING: {
                    result = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        if (!"class java.lang.String".equals(classFullName)) break;
                        result = this.formateDate(entity, cell.getDateCellValue());
                        break;
                    }
                    result = this.readNumericCell(cell);
                    break;
                }
                case BOOLEAN: {
                    result = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    break;
                }
                case ERROR: {
                    break;
                }
                case FORMULA: {
                    try {
                        result = this.readNumericCell(cell);
                        break;
                    }
                    catch (Exception e1) {
                        try {
                            result = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                            break;
                        }
                        catch (Exception e2) {
                            throw new RuntimeException("\u83b7\u53d6\u516c\u5f0f\u7c7b\u578b\u7684\u5355\u5143\u683c\u5931\u8d25", e2);
                        }
                    }
                }
            }
        }
        return result;
    }

    private Object readNumericCell(Cell cell) {
        Number result = null;
        double value = cell.getNumericCellValue();
        result = (double)((int)value) == value ? (Number)((int)value) : (Number)value;
        return result;
    }

    private java.util.Date getDateData(ExcelImportEntity entity, String value) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat()) && StringUtils.isNotEmpty((CharSequence)value)) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getFormat());
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25,\u683c\u5f0f\u5316:{},\u503c:{}", (Object)entity.getFormat(), (Object)value);
                throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
            }
        }
        return null;
    }

    private String formateDate(ExcelImportEntity entity, java.util.Date value) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat()) && value != null) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getFormat());
            return format.format(value);
        }
        return null;
    }

    public Object getValue(IExcelDataHandler<?> dataHandler, Object object, String cell, Map<String, ExcelImportEntity> excelParams, String titleString, IExcelDictHandler dictHandler) throws Exception {
        ExcelImportEntity entity = excelParams.get(titleString);
        String classFullName = "class java.lang.Object";
        Class clazz = null;
        if (!(object instanceof Map)) {
            Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
            Type[] ts = setMethod.getGenericParameterTypes();
            classFullName = ts[0].toString();
            clazz = (Class)ts[0];
        }
        Object result = cell;
        if (entity != null) {
            result = this.handlerSuffix(entity.getSuffix(), result);
            result = this.replaceValue(entity.getReplace(), result);
            result = this.replaceValue(entity.getReplace(), result);
            if (dictHandler != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getDict()})) {
                dictHandler.toValue(entity.getDict(), object, entity.getName(), result);
            }
        }
        result = this.handlerValue(dataHandler, object, result, titleString);
        return this.getValueByType(classFullName, result, entity, clazz);
    }

    public Object getValue(IExcelDataHandler<?> dataHandler, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, IExcelDictHandler dictHandler) throws Exception {
        ExcelImportEntity entity = excelParams.get(titleString);
        String classFullName = "class java.lang.Object";
        Class clazz = null;
        if (!(object instanceof Map)) {
            Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
            Type[] ts = setMethod.getGenericParameterTypes();
            classFullName = ts[0].toString();
            clazz = (Class)ts[0];
        }
        Object result = this.getCellValue(classFullName, cell, entity);
        if (entity != null) {
            result = this.handlerSuffix(entity.getSuffix(), result);
            result = this.replaceValue(entity.getReplace(), result);
            result = this.replaceValue(entity.getReplace(), result);
            if (dictHandler != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getDict()})) {
                dictHandler.toValue(entity.getDict(), object, entity.getName(), result);
            }
        }
        result = this.handlerValue(dataHandler, object, result, titleString);
        return this.getValueByType(classFullName, result, entity, clazz);
    }

    public Object getValue(IExcelDataHandler<?> dataHandler, Object object, SaxReadCellEntity cellEntity, Map<String, ExcelImportEntity> excelParams, String titleString) {
        ExcelImportEntity entity = excelParams.get(titleString);
        Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
        Type[] ts = setMethod.getGenericParameterTypes();
        String classFullName = ts[0].toString();
        Object result = cellEntity.getValue();
        result = this.handlerSuffix(entity.getSuffix(), result);
        result = this.replaceValue(entity.getReplace(), result);
        result = this.handlerValue(dataHandler, object, result, titleString);
        return this.getValueByType(classFullName, result, entity, (Class)ts[0]);
    }

    private Object handlerSuffix(String suffix, Object result) {
        if (StringUtils.isNotEmpty((CharSequence)suffix) && result != null && result.toString().endsWith(suffix)) {
            String temp = result.toString();
            return temp.substring(0, temp.length() - suffix.length());
        }
        return result;
    }

    private Object getValueByType(String classFullName, Object result, ExcelImportEntity entity, Class clazz) {
        try {
            if (result == null || StringUtils.isBlank((CharSequence)result.toString())) {
                return null;
            }
            if ("class java.util.Date".equals(classFullName) && result instanceof java.util.Date) {
                return result;
            }
            if ("class java.util.Date".equals(classFullName) && result instanceof String) {
                return DateUtils.parseDate((String)result.toString(), (String[])new String[]{entity.getFormat()});
            }
            if ("class java.sql.Date".equals(classFullName) && result instanceof Date) {
                return result;
            }
            if ("class java.lang.Boolean".equals(classFullName) || "boolean".equals(classFullName)) {
                return Boolean.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Double".equals(classFullName) || "double".equals(classFullName)) {
                return Double.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Long".equals(classFullName) || "long".equals(classFullName)) {
                try {
                    return Long.valueOf(String.valueOf(result));
                }
                catch (Exception e) {
                    return Double.valueOf(String.valueOf(result)).longValue();
                }
            }
            if ("class java.lang.Float".equals(classFullName) || "float".equals(classFullName)) {
                return Float.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Integer".equals(classFullName) || "int".equals(classFullName)) {
                try {
                    return Integer.valueOf(String.valueOf(result));
                }
                catch (Exception e) {
                    return Double.valueOf(String.valueOf(result)).intValue();
                }
            }
            if ("class java.math.BigDecimal".equals(classFullName)) {
                return new BigDecimal(String.valueOf(result));
            }
            if ("class java.lang.String".equals(classFullName)) {
                if (result instanceof String) {
                    return result;
                }
                if (result instanceof Double) {
                    return PoiPublicUtil.doubleToString((Double)result);
                }
                return String.valueOf(result);
            }
            if (clazz != null && clazz.isEnum()) {
                if (StringUtils.isNotEmpty((CharSequence)entity.getEnumImportMethod())) {
                    return PoiReflectorUtil.fromCache(clazz).execEnumStaticMethod(entity.getEnumImportMethod(), result);
                }
                return Enum.valueOf(clazz, result.toString());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
        }
    }

    private Object handlerValue(IExcelDataHandler dataHandler, Object object, Object result, String titleString) {
        if (dataHandler == null || dataHandler.getNeedHandlerFields() == null || dataHandler.getNeedHandlerFields().length == 0) {
            return result;
        }
        if (this.handlerList == null) {
            this.handlerList = Arrays.asList(dataHandler.getNeedHandlerFields());
        }
        if (this.handlerList.contains(titleString)) {
            return dataHandler.importHandler(object, titleString, result);
        }
        return result;
    }

    private Object replaceValue(String[] replace, Object result) {
        if (replace != null && replace.length > 0) {
            String temp = String.valueOf(result);
            for (int i = 0; i < replace.length; ++i) {
                String[] tempArr = replace[i].split("_");
                if (!temp.equals(tempArr[0])) continue;
                return tempArr[1];
            }
        }
        return result;
    }
}

