/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.MFN_M08_MF_TEST_NUMERIC;
import ca.uhn.hl7v2.model.v251.segment.MFI;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M08
extends AbstractMessage {
    public MFN_M08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public MFN_M08() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M08_MF_TEST_NUMERIC.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M08_MF_TEST_NUMERIC getMF_TEST_NUMERIC() {
        MFN_M08_MF_TEST_NUMERIC ret = null;
        try {
            ret = (MFN_M08_MF_TEST_NUMERIC)this.get("MF_TEST_NUMERIC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M08_MF_TEST_NUMERIC getMF_TEST_NUMERIC(int rep) {
        MFN_M08_MF_TEST_NUMERIC ret = null;
        try {
            ret = (MFN_M08_MF_TEST_NUMERIC)this.get("MF_TEST_NUMERIC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMF_TEST_NUMERICReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_TEST_NUMERIC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMF_TEST_NUMERIC(MFN_M08_MF_TEST_NUMERIC structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_NUMERIC", (Structure)structure, rep);
    }

    public MFN_M08_MF_TEST_NUMERIC insertMF_TEST_NUMERIC(int rep) throws HL7Exception {
        return (MFN_M08_MF_TEST_NUMERIC)super.insertRepetition("MF_TEST_NUMERIC", rep);
    }

    public MFN_M08_MF_TEST_NUMERIC removeMF_TEST_NUMERIC(int rep) throws HL7Exception {
        return (MFN_M08_MF_TEST_NUMERIC)super.removeRepetition("MF_TEST_NUMERIC", rep);
    }
}

