/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader.selenium;

import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

class WebDriverPool {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final int DEFAULT_CAPACITY = 5;
    private final int capacity;
    private static final int STAT_RUNNING = 1;
    private static final int STAT_CLODED = 2;
    private AtomicInteger stat = new AtomicInteger(1);
    private WebDriver mDriver = null;
    private boolean mAutoQuitDriver = true;
    private static final String DEFAULT_CONFIG_FILE = "/data/webmagic/webmagic-selenium/config.ini";
    private static final String DRIVER_FIREFOX = "firefox";
    private static final String DRIVER_CHROME = "chrome";
    private static final String DRIVER_PHANTOMJS = "phantomjs";
    protected static Properties sConfig;
    protected static DesiredCapabilities sCaps;
    private List<WebDriver> webDriverList = Collections.synchronizedList(new ArrayList());
    private BlockingDeque<WebDriver> innerQueue = new LinkedBlockingDeque<WebDriver>();

    public void configure() throws IOException {
        sConfig = new Properties();
        String configFile = DEFAULT_CONFIG_FILE;
        if (System.getProperty("selenuim_config") != null) {
            configFile = System.getProperty("selenuim_config");
        }
        sConfig.load(new FileReader(configFile));
        sCaps = new DesiredCapabilities();
        sCaps.setJavascriptEnabled(true);
        sCaps.setCapability("takesScreenshot", false);
        String driver = sConfig.getProperty("driver", DRIVER_PHANTOMJS);
        if (driver.equals(DRIVER_PHANTOMJS)) {
            if (sConfig.getProperty("phantomjs_exec_path") == null) {
                throw new IOException(String.format("Property '%s' not set!", "phantomjs.binary.path"));
            }
            sCaps.setCapability("phantomjs.binary.path", sConfig.getProperty("phantomjs_exec_path"));
            if (sConfig.getProperty("phantomjs_driver_path") != null) {
                System.out.println("Test will use an external GhostDriver");
                sCaps.setCapability("phantomjs.ghostdriver.path", sConfig.getProperty("phantomjs_driver_path"));
            } else {
                System.out.println("Test will use PhantomJS internal GhostDriver");
            }
        }
        ArrayList<String> cliArgsCap = new ArrayList<String>();
        cliArgsCap.add("--web-security=false");
        cliArgsCap.add("--ssl-protocol=any");
        cliArgsCap.add("--ignore-ssl-errors=true");
        sCaps.setCapability("phantomjs.cli.args", cliArgsCap);
        sCaps.setCapability("phantomjs.ghostdriver.cli.args", (Object)new String[]{"--logLevel=" + (sConfig.getProperty("phantomjs_driver_loglevel") != null ? sConfig.getProperty("phantomjs_driver_loglevel") : "INFO")});
        if (this.isUrl(driver)) {
            sCaps.setBrowserName(DRIVER_PHANTOMJS);
            this.mDriver = new RemoteWebDriver(new URL(driver), (Capabilities)sCaps);
        } else if (driver.equals(DRIVER_FIREFOX)) {
            this.mDriver = new FirefoxDriver((Capabilities)sCaps);
        } else if (driver.equals(DRIVER_CHROME)) {
            this.mDriver = new ChromeDriver((Capabilities)sCaps);
        } else if (driver.equals(DRIVER_PHANTOMJS)) {
            this.mDriver = new PhantomJSDriver((Capabilities)sCaps);
        }
    }

    private boolean isUrl(String urlString) {
        try {
            new URL(urlString);
            return true;
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public WebDriverPool(int capacity) {
        this.capacity = capacity;
    }

    public WebDriverPool() {
        this(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver get() throws InterruptedException {
        this.checkRunning();
        WebDriver poll = this.innerQueue.poll();
        if (poll != null) {
            return poll;
        }
        if (this.webDriverList.size() < this.capacity) {
            List<WebDriver> list = this.webDriverList;
            synchronized (list) {
                if (this.webDriverList.size() < this.capacity) {
                    try {
                        this.configure();
                        this.innerQueue.add(this.mDriver);
                        this.webDriverList.add(this.mDriver);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.innerQueue.take();
    }

    public void returnToPool(WebDriver webDriver) {
        this.checkRunning();
        this.innerQueue.add(webDriver);
    }

    protected void checkRunning() {
        if (!this.stat.compareAndSet(1, 1)) {
            throw new IllegalStateException("Already closed!");
        }
    }

    public void closeAll() {
        boolean b = this.stat.compareAndSet(1, 2);
        if (!b) {
            throw new IllegalStateException("Already closed!");
        }
        for (WebDriver webDriver : this.webDriverList) {
            this.logger.info((Object)("Quit webDriver" + webDriver));
            webDriver.quit();
            Object var3_3 = null;
        }
    }
}

