/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.AccountModification;
import software.amazon.awssdk.services.workspaces.model.AccountModificationListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountModificationsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeAccountModificationsResponse> {
    private static final SdkField<List<AccountModification>> ACCOUNT_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountModifications").getter(DescribeAccountModificationsResponse.getter(DescribeAccountModificationsResponse::accountModifications)).setter(DescribeAccountModificationsResponse.setter(Builder::accountModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountModification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAccountModificationsResponse.getter(DescribeAccountModificationsResponse::nextToken)).setter(DescribeAccountModificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_MODIFICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountModification> accountModifications;
    private final String nextToken;

    private DescribeAccountModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.accountModifications = builder.accountModifications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountModifications() {
        return this.accountModifications != null && !(this.accountModifications instanceof SdkAutoConstructList);
    }

    public final List<AccountModification> accountModifications() {
        return this.accountModifications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountModifications() ? this.accountModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountModificationsResponse)) {
            return false;
        }
        DescribeAccountModificationsResponse other = (DescribeAccountModificationsResponse)((Object)obj);
        return this.hasAccountModifications() == other.hasAccountModifications() && Objects.equals(this.accountModifications(), other.accountModifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountModificationsResponse").add("AccountModifications", this.hasAccountModifications() ? this.accountModifications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountModifications": {
                return Optional.ofNullable(clazz.cast(this.accountModifications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountModificationsResponse, T> g) {
        return obj -> g.apply((DescribeAccountModificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<AccountModification> accountModifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountModificationsResponse model) {
            super(model);
            this.accountModifications(model.accountModifications);
            this.nextToken(model.nextToken);
        }

        public final List<AccountModification.Builder> getAccountModifications() {
            List<AccountModification.Builder> result = AccountModificationListCopier.copyToBuilder(this.accountModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accountModifications(Collection<AccountModification> accountModifications) {
            this.accountModifications = AccountModificationListCopier.copy(accountModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountModifications(AccountModification ... accountModifications) {
            this.accountModifications(Arrays.asList(accountModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountModifications(Consumer<AccountModification.Builder> ... accountModifications) {
            this.accountModifications(Stream.of(accountModifications).map(c -> (AccountModification)((AccountModification.Builder)AccountModification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountModifications(Collection<AccountModification.BuilderImpl> accountModifications) {
            this.accountModifications = AccountModificationListCopier.copyFromBuilder(accountModifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccountModificationsResponse build() {
            return new DescribeAccountModificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountModificationsResponse> {
        public Builder accountModifications(Collection<AccountModification> var1);

        public Builder accountModifications(AccountModification ... var1);

        public Builder accountModifications(Consumer<AccountModification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

