/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SampledHTTPRequest;
import software.amazon.awssdk.services.waf.model.SampledHTTPRequestsCopier;
import software.amazon.awssdk.services.waf.model.TimeWindow;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSampledRequestsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, GetSampledRequestsResponse> {
    private static final SdkField<List<SampledHTTPRequest>> SAMPLED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SampledRequests").getter(GetSampledRequestsResponse.getter(GetSampledRequestsResponse::sampledRequests)).setter(GetSampledRequestsResponse.setter(Builder::sampledRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampledHTTPRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> POPULATION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PopulationSize").getter(GetSampledRequestsResponse.getter(GetSampledRequestsResponse::populationSize)).setter(GetSampledRequestsResponse.setter(Builder::populationSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PopulationSize").build()}).build();
    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeWindow").getter(GetSampledRequestsResponse.getter(GetSampledRequestsResponse::timeWindow)).setter(GetSampledRequestsResponse.setter(Builder::timeWindow)).constructor(TimeWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLED_REQUESTS_FIELD, POPULATION_SIZE_FIELD, TIME_WINDOW_FIELD));
    private final List<SampledHTTPRequest> sampledRequests;
    private final Long populationSize;
    private final TimeWindow timeWindow;

    private GetSampledRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.sampledRequests = builder.sampledRequests;
        this.populationSize = builder.populationSize;
        this.timeWindow = builder.timeWindow;
    }

    public final boolean hasSampledRequests() {
        return this.sampledRequests != null && !(this.sampledRequests instanceof SdkAutoConstructList);
    }

    public final List<SampledHTTPRequest> sampledRequests() {
        return this.sampledRequests;
    }

    public final Long populationSize() {
        return this.populationSize;
    }

    public final TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampledRequests() ? this.sampledRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.populationSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeWindow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsResponse)) {
            return false;
        }
        GetSampledRequestsResponse other = (GetSampledRequestsResponse)((Object)obj);
        return this.hasSampledRequests() == other.hasSampledRequests() && Objects.equals(this.sampledRequests(), other.sampledRequests()) && Objects.equals(this.populationSize(), other.populationSize()) && Objects.equals(this.timeWindow(), other.timeWindow());
    }

    public final String toString() {
        return ToString.builder((String)"GetSampledRequestsResponse").add("SampledRequests", this.hasSampledRequests() ? this.sampledRequests() : null).add("PopulationSize", (Object)this.populationSize()).add("TimeWindow", (Object)this.timeWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SampledRequests": {
                return Optional.ofNullable(clazz.cast(this.sampledRequests()));
            }
            case "PopulationSize": {
                return Optional.ofNullable(clazz.cast(this.populationSize()));
            }
            case "TimeWindow": {
                return Optional.ofNullable(clazz.cast(this.timeWindow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsResponse, T> g) {
        return obj -> g.apply((GetSampledRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private List<SampledHTTPRequest> sampledRequests = DefaultSdkAutoConstructList.getInstance();
        private Long populationSize;
        private TimeWindow timeWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsResponse model) {
            super(model);
            this.sampledRequests(model.sampledRequests);
            this.populationSize(model.populationSize);
            this.timeWindow(model.timeWindow);
        }

        public final List<SampledHTTPRequest.Builder> getSampledRequests() {
            List<SampledHTTPRequest.Builder> result = SampledHTTPRequestsCopier.copyToBuilder(this.sampledRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sampledRequests(Collection<SampledHTTPRequest> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copy(sampledRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampledRequests(SampledHTTPRequest ... sampledRequests) {
            this.sampledRequests(Arrays.asList(sampledRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampledRequests(Consumer<SampledHTTPRequest.Builder> ... sampledRequests) {
            this.sampledRequests(Stream.of(sampledRequests).map(c -> (SampledHTTPRequest)((SampledHTTPRequest.Builder)SampledHTTPRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSampledRequests(Collection<SampledHTTPRequest.BuilderImpl> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copyFromBuilder(sampledRequests);
        }

        public final Long getPopulationSize() {
            return this.populationSize;
        }

        @Override
        public final Builder populationSize(Long populationSize) {
            this.populationSize = populationSize;
            return this;
        }

        public final void setPopulationSize(Long populationSize) {
            this.populationSize = populationSize;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        public GetSampledRequestsResponse build() {
            return new GetSampledRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSampledRequestsResponse> {
        public Builder sampledRequests(Collection<SampledHTTPRequest> var1);

        public Builder sampledRequests(SampledHTTPRequest ... var1);

        public Builder sampledRequests(Consumer<SampledHTTPRequest.Builder> ... var1);

        public Builder populationSize(Long var1);

        public Builder timeWindow(TimeWindow var1);

        default public Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return this.timeWindow((TimeWindow)((TimeWindow.Builder)TimeWindow.builder().applyMutation(timeWindow)).build());
        }
    }
}

