/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMedicalVocabularyRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, UpdateMedicalVocabularyRequest> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(UpdateMedicalVocabularyRequest.getter(UpdateMedicalVocabularyRequest::vocabularyName)).setter(UpdateMedicalVocabularyRequest.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(UpdateMedicalVocabularyRequest.getter(UpdateMedicalVocabularyRequest::languageCodeAsString)).setter(UpdateMedicalVocabularyRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFileUri").getter(UpdateMedicalVocabularyRequest.getter(UpdateMedicalVocabularyRequest::vocabularyFileUri)).setter(UpdateMedicalVocabularyRequest.setter(Builder::vocabularyFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFileUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, LANGUAGE_CODE_FIELD, VOCABULARY_FILE_URI_FIELD));
    private final String vocabularyName;
    private final String languageCode;
    private final String vocabularyFileUri;

    private UpdateMedicalVocabularyRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyFileUri = builder.vocabularyFileUri;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String vocabularyFileUri() {
        return this.vocabularyFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFileUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMedicalVocabularyRequest)) {
            return false;
        }
        UpdateMedicalVocabularyRequest other = (UpdateMedicalVocabularyRequest)((Object)obj);
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyFileUri(), other.vocabularyFileUri());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMedicalVocabularyRequest").add("VocabularyName", (Object)this.vocabularyName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyFileUri", (Object)this.vocabularyFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFileUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMedicalVocabularyRequest, T> g) {
        return obj -> g.apply((UpdateMedicalVocabularyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String languageCode;
        private String vocabularyFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMedicalVocabularyRequest model) {
            super(model);
            this.vocabularyName(model.vocabularyName);
            this.languageCode(model.languageCode);
            this.vocabularyFileUri(model.vocabularyFileUri);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVocabularyFileUri() {
            return this.vocabularyFileUri;
        }

        @Override
        public final Builder vocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        public final void setVocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMedicalVocabularyRequest build() {
            return new UpdateMedicalVocabularyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMedicalVocabularyRequest> {
        public Builder vocabularyName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder vocabularyFileUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

