/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BaseModelName {
    NARROW_BAND("NarrowBand"),
    WIDE_BAND("WideBand"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BaseModelName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BaseModelName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BaseModelName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BaseModelName> knownValues() {
        return Stream.of(BaseModelName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

