/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest;
import software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse;

public class GetCanaryRunsPublisher
implements SdkPublisher<GetCanaryRunsResponse> {
    private final SyntheticsAsyncClient client;
    private final GetCanaryRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCanaryRunsPublisher(SyntheticsAsyncClient client, GetCanaryRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCanaryRunsPublisher(SyntheticsAsyncClient client, GetCanaryRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCanaryRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCanaryRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCanaryRunsResponseFetcher
    implements AsyncPageFetcher<GetCanaryRunsResponse> {
        private GetCanaryRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetCanaryRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCanaryRunsResponse> nextPage(GetCanaryRunsResponse previousPage) {
            if (previousPage == null) {
                return GetCanaryRunsPublisher.this.client.getCanaryRuns(GetCanaryRunsPublisher.this.firstRequest);
            }
            return GetCanaryRunsPublisher.this.client.getCanaryRuns((GetCanaryRunsRequest)((Object)GetCanaryRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

