/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CanaryState {
    CREATING("CREATING"),
    READY("READY"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    UPDATING("UPDATING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    ERROR("ERROR"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CanaryState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CanaryState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CanaryState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CanaryState> knownValues() {
        return Stream.of(CanaryState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

