/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse;
import software.amazon.awssdk.services.storagegateway.model.PoolInfo;

public class ListTapePoolsPublisher
implements SdkPublisher<ListTapePoolsResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListTapePoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTapePoolsPublisher(StorageGatewayAsyncClient client, ListTapePoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTapePoolsPublisher(StorageGatewayAsyncClient client, ListTapePoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTapePoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTapePoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PoolInfo> poolInfos() {
        Function<ListTapePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.poolInfos() != null) {
                return response.poolInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTapePoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTapePoolsResponseFetcher
    implements AsyncPageFetcher<ListTapePoolsResponse> {
        private ListTapePoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListTapePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListTapePoolsResponse> nextPage(ListTapePoolsResponse previousPage) {
            if (previousPage == null) {
                return ListTapePoolsPublisher.this.client.listTapePools(ListTapePoolsPublisher.this.firstRequest);
            }
            return ListTapePoolsPublisher.this.client.listTapePools((ListTapePoolsRequest)((Object)ListTapePoolsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

