/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterLabelListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnlabelParameterVersionResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, UnlabelParameterVersionResponse> {
    private static final SdkField<List<String>> REMOVED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemovedLabels").getter(UnlabelParameterVersionResponse.getter(UnlabelParameterVersionResponse::removedLabels)).setter(UnlabelParameterVersionResponse.setter(Builder::removedLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovedLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INVALID_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidLabels").getter(UnlabelParameterVersionResponse.getter(UnlabelParameterVersionResponse::invalidLabels)).setter(UnlabelParameterVersionResponse.setter(Builder::invalidLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOVED_LABELS_FIELD, INVALID_LABELS_FIELD));
    private final List<String> removedLabels;
    private final List<String> invalidLabels;

    private UnlabelParameterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.removedLabels = builder.removedLabels;
        this.invalidLabels = builder.invalidLabels;
    }

    public final boolean hasRemovedLabels() {
        return this.removedLabels != null && !(this.removedLabels instanceof SdkAutoConstructList);
    }

    public final List<String> removedLabels() {
        return this.removedLabels;
    }

    public final boolean hasInvalidLabels() {
        return this.invalidLabels != null && !(this.invalidLabels instanceof SdkAutoConstructList);
    }

    public final List<String> invalidLabels() {
        return this.invalidLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemovedLabels() ? this.removedLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidLabels() ? this.invalidLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlabelParameterVersionResponse)) {
            return false;
        }
        UnlabelParameterVersionResponse other = (UnlabelParameterVersionResponse)((Object)obj);
        return this.hasRemovedLabels() == other.hasRemovedLabels() && Objects.equals(this.removedLabels(), other.removedLabels()) && this.hasInvalidLabels() == other.hasInvalidLabels() && Objects.equals(this.invalidLabels(), other.invalidLabels());
    }

    public final String toString() {
        return ToString.builder((String)"UnlabelParameterVersionResponse").add("RemovedLabels", this.hasRemovedLabels() ? this.removedLabels() : null).add("InvalidLabels", this.hasInvalidLabels() ? this.invalidLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemovedLabels": {
                return Optional.ofNullable(clazz.cast(this.removedLabels()));
            }
            case "InvalidLabels": {
                return Optional.ofNullable(clazz.cast(this.invalidLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnlabelParameterVersionResponse, T> g) {
        return obj -> g.apply((UnlabelParameterVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<String> removedLabels = DefaultSdkAutoConstructList.getInstance();
        private List<String> invalidLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnlabelParameterVersionResponse model) {
            super(model);
            this.removedLabels(model.removedLabels);
            this.invalidLabels(model.invalidLabels);
        }

        public final Collection<String> getRemovedLabels() {
            if (this.removedLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removedLabels;
        }

        @Override
        public final Builder removedLabels(Collection<String> removedLabels) {
            this.removedLabels = ParameterLabelListCopier.copy(removedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedLabels(String ... removedLabels) {
            this.removedLabels(Arrays.asList(removedLabels));
            return this;
        }

        public final void setRemovedLabels(Collection<String> removedLabels) {
            this.removedLabels = ParameterLabelListCopier.copy(removedLabels);
        }

        public final Collection<String> getInvalidLabels() {
            if (this.invalidLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invalidLabels;
        }

        @Override
        public final Builder invalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidLabels(String ... invalidLabels) {
            this.invalidLabels(Arrays.asList(invalidLabels));
            return this;
        }

        public final void setInvalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
        }

        @Override
        public UnlabelParameterVersionResponse build() {
            return new UnlabelParameterVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnlabelParameterVersionResponse> {
        public Builder removedLabels(Collection<String> var1);

        public Builder removedLabels(String ... var1);

        public Builder invalidLabels(Collection<String> var1);

        public Builder invalidLabels(String ... var1);
    }
}

