/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobListEntry> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(JobListEntry.getter(JobListEntry::jobId)).setter(JobListEntry.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobState").getter(JobListEntry.getter(JobListEntry::jobStateAsString)).setter(JobListEntry.setter(Builder::jobState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobState").build()}).build();
    private static final SdkField<Boolean> IS_MASTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMaster").getter(JobListEntry.getter(JobListEntry::isMaster)).setter(JobListEntry.setter(Builder::isMaster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMaster").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(JobListEntry.getter(JobListEntry::jobTypeAsString)).setter(JobListEntry.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballType").getter(JobListEntry.getter(JobListEntry::snowballTypeAsString)).setter(JobListEntry.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(JobListEntry.getter(JobListEntry::creationDate)).setter(JobListEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(JobListEntry.getter(JobListEntry::description)).setter(JobListEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_STATE_FIELD, IS_MASTER_FIELD, JOB_TYPE_FIELD, SNOWBALL_TYPE_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobState;
    private final Boolean isMaster;
    private final String jobType;
    private final String snowballType;
    private final Instant creationDate;
    private final String description;

    private JobListEntry(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.isMaster = builder.isMaster;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobState jobState() {
        return JobState.fromValue(this.jobState);
    }

    public final String jobStateAsString() {
        return this.jobState;
    }

    public final Boolean isMaster() {
        return this.isMaster;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public final String snowballTypeAsString() {
        return this.snowballType;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMaster());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListEntry)) {
            return false;
        }
        JobListEntry other = (JobListEntry)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobStateAsString(), other.jobStateAsString()) && Objects.equals(this.isMaster(), other.isMaster()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"JobListEntry").add("JobId", (Object)this.jobId()).add("JobState", (Object)this.jobStateAsString()).add("IsMaster", (Object)this.isMaster()).add("JobType", (Object)this.jobTypeAsString()).add("SnowballType", (Object)this.snowballTypeAsString()).add("CreationDate", (Object)this.creationDate()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobState": {
                return Optional.ofNullable(clazz.cast(this.jobStateAsString()));
            }
            case "IsMaster": {
                return Optional.ofNullable(clazz.cast(this.isMaster()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobListEntry, T> g) {
        return obj -> g.apply((JobListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobState;
        private Boolean isMaster;
        private String jobType;
        private String snowballType;
        private Instant creationDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListEntry model) {
            this.jobId(model.jobId);
            this.jobState(model.jobState);
            this.isMaster(model.isMaster);
            this.jobType(model.jobType);
            this.snowballType(model.snowballType);
            this.creationDate(model.creationDate);
            this.description(model.description);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return this.jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState == null ? null : jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final Boolean getIsMaster() {
            return this.isMaster;
        }

        @Override
        public final Builder isMaster(Boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public final void setIsMaster(Boolean isMaster) {
            this.isMaster = isMaster;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public JobListEntry build() {
            return new JobListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobListEntry> {
        public Builder jobId(String var1);

        public Builder jobState(String var1);

        public Builder jobState(JobState var1);

        public Builder isMaster(Boolean var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);
    }
}

