/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LicenseType {
    AWS("AWS"),
    BYOL("BYOL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LicenseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LicenseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LicenseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LicenseType> knownValues() {
        return Stream.of(LicenseType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

