/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerAsyncClient;
import software.amazon.awssdk.services.signer.model.ListSigningProfilesRequest;
import software.amazon.awssdk.services.signer.model.ListSigningProfilesResponse;

public class ListSigningProfilesPublisher
implements SdkPublisher<ListSigningProfilesResponse> {
    private final SignerAsyncClient client;
    private final ListSigningProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSigningProfilesPublisher(SignerAsyncClient client, ListSigningProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSigningProfilesPublisher(SignerAsyncClient client, ListSigningProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSigningProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSigningProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSigningProfilesResponseFetcher
    implements AsyncPageFetcher<ListSigningProfilesResponse> {
        private ListSigningProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSigningProfilesResponse> nextPage(ListSigningProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningProfilesPublisher.this.client.listSigningProfiles(ListSigningProfilesPublisher.this.firstRequest);
            }
            return ListSigningProfilesPublisher.this.client.listSigningProfiles((ListSigningProfilesRequest)((Object)ListSigningProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

