/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SubResourceType {
    IP("IP"),
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SubResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SubResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SubResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SubResourceType> knownValues() {
        return Stream.of(SubResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

