/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.LogDestination;
import software.amazon.awssdk.services.sfn.model.LogDestinationListCopier;
import software.amazon.awssdk.services.sfn.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfiguration> {
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(LoggingConfiguration.getter(LoggingConfiguration::levelAsString)).setter(LoggingConfiguration.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<Boolean> INCLUDE_EXECUTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeExecutionData").getter(LoggingConfiguration.getter(LoggingConfiguration::includeExecutionData)).setter(LoggingConfiguration.setter(Builder::includeExecutionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeExecutionData").build()}).build();
    private static final SdkField<List<LogDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(LoggingConfiguration.getter(LoggingConfiguration::destinations)).setter(LoggingConfiguration.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_FIELD, INCLUDE_EXECUTION_DATA_FIELD, DESTINATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String level;
    private final Boolean includeExecutionData;
    private final List<LogDestination> destinations;

    private LoggingConfiguration(BuilderImpl builder) {
        this.level = builder.level;
        this.includeExecutionData = builder.includeExecutionData;
        this.destinations = builder.destinations;
    }

    public final LogLevel level() {
        return LogLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final Boolean includeExecutionData() {
        return this.includeExecutionData;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<LogDestination> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeExecutionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        return Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.includeExecutionData(), other.includeExecutionData()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfiguration").add("Level", (Object)this.levelAsString()).add("IncludeExecutionData", (Object)this.includeExecutionData()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "includeExecutionData": {
                return Optional.ofNullable(clazz.cast(this.includeExecutionData()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String level;
        private Boolean includeExecutionData;
        private List<LogDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            this.level(model.level);
            this.includeExecutionData(model.includeExecutionData);
            this.destinations(model.destinations);
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LogLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Boolean getIncludeExecutionData() {
            return this.includeExecutionData;
        }

        @Override
        public final Builder includeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
            return this;
        }

        public final void setIncludeExecutionData(Boolean includeExecutionData) {
            this.includeExecutionData = includeExecutionData;
        }

        public final List<LogDestination.Builder> getDestinations() {
            List<LogDestination.Builder> result = LogDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinations(Collection<LogDestination> destinations) {
            this.destinations = LogDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(LogDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<LogDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (LogDestination)((LogDestination.Builder)LogDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<LogDestination.BuilderImpl> destinations) {
            this.destinations = LogDestinationListCopier.copyFromBuilder(destinations);
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfiguration> {
        public Builder level(String var1);

        public Builder level(LogLevel var1);

        public Builder includeExecutionData(Boolean var1);

        public Builder destinations(Collection<LogDestination> var1);

        public Builder destinations(LogDestination ... var1);

        public Builder destinations(Consumer<LogDestination.Builder> ... var1);
    }
}

