/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainStatisticsReportRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, GetDomainStatisticsReportRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(GetDomainStatisticsReportRequest.getter(GetDomainStatisticsReportRequest::domain)).setter(GetDomainStatisticsReportRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Domain").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(GetDomainStatisticsReportRequest.getter(GetDomainStatisticsReportRequest::startDate)).setter(GetDomainStatisticsReportRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(GetDomainStatisticsReportRequest.getter(GetDomainStatisticsReportRequest::endDate)).setter(GetDomainStatisticsReportRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, START_DATE_FIELD, END_DATE_FIELD));
    private final String domain;
    private final Instant startDate;
    private final Instant endDate;

    private GetDomainStatisticsReportRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    public final String domain() {
        return this.domain;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainStatisticsReportRequest)) {
            return false;
        }
        GetDomainStatisticsReportRequest other = (GetDomainStatisticsReportRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainStatisticsReportRequest").add("Domain", (Object)this.domain()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainStatisticsReportRequest, T> g) {
        return obj -> g.apply((GetDomainStatisticsReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String domain;
        private Instant startDate;
        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainStatisticsReportRequest model) {
            super(model);
            this.domain(model.domain);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainStatisticsReportRequest build() {
            return new GetDomainStatisticsReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainStatisticsReportRequest> {
        public Builder domain(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

