/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;

public class ListOperationsPublisher
implements SdkPublisher<ListOperationsResponse> {
    private final ServiceDiscoveryAsyncClient client;
    private final ListOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOperationsPublisher(ServiceDiscoveryAsyncClient client, ListOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOperationsPublisher(ServiceDiscoveryAsyncClient client, ListOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListOperationsResponseFetcher
    implements AsyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOperationsResponse> nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsPublisher.this.client.listOperations(ListOperationsPublisher.this.firstRequest);
            }
            return ListOperationsPublisher.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

