/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;

public class GetInstancesHealthStatusPublisher
implements SdkPublisher<GetInstancesHealthStatusResponse> {
    private final ServiceDiscoveryAsyncClient client;
    private final GetInstancesHealthStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInstancesHealthStatusPublisher(ServiceDiscoveryAsyncClient client, GetInstancesHealthStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInstancesHealthStatusPublisher(ServiceDiscoveryAsyncClient client, GetInstancesHealthStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInstancesHealthStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInstancesHealthStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetInstancesHealthStatusResponseFetcher
    implements AsyncPageFetcher<GetInstancesHealthStatusResponse> {
        private GetInstancesHealthStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetInstancesHealthStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInstancesHealthStatusResponse> nextPage(GetInstancesHealthStatusResponse previousPage) {
            if (previousPage == null) {
                return GetInstancesHealthStatusPublisher.this.client.getInstancesHealthStatus(GetInstancesHealthStatusPublisher.this.firstRequest);
            }
            return GetInstancesHealthStatusPublisher.this.client.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)GetInstancesHealthStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

