/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;

public class GetInstancesHealthStatusIterable
implements SdkIterable<GetInstancesHealthStatusResponse> {
    private final ServiceDiscoveryClient client;
    private final GetInstancesHealthStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInstancesHealthStatusIterable(ServiceDiscoveryClient client, GetInstancesHealthStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInstancesHealthStatusResponseFetcher();
    }

    public Iterator<GetInstancesHealthStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetInstancesHealthStatusResponseFetcher
    implements SyncPageFetcher<GetInstancesHealthStatusResponse> {
        private GetInstancesHealthStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetInstancesHealthStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInstancesHealthStatusResponse nextPage(GetInstancesHealthStatusResponse previousPage) {
            if (previousPage == null) {
                return GetInstancesHealthStatusIterable.this.client.getInstancesHealthStatus(GetInstancesHealthStatusIterable.this.firstRequest);
            }
            return GetInstancesHealthStatusIterable.this.client.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)GetInstancesHealthStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

