/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutputsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactPreferences;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstruction;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstructionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisioningParametersResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
    private static final SdkField<List<ProvisioningArtifactParameter>> PROVISIONING_ARTIFACT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningArtifactParameters").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::provisioningArtifactParameters)).setter(DescribeProvisioningParametersResponse.setter(Builder::provisioningArtifactParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifactParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConstraintSummary>> CONSTRAINT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConstraintSummaries").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::constraintSummaries)).setter(DescribeProvisioningParametersResponse.setter(Builder::constraintSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConstraintSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageInstruction>> USAGE_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsageInstructions").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::usageInstructions)).setter(DescribeProvisioningParametersResponse.setter(Builder::usageInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageInstructions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagOptionSummary>> TAG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagOptions").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::tagOptions)).setter(DescribeProvisioningParametersResponse.setter(Builder::tagOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagOptionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisioningArtifactPreferences> PROVISIONING_ARTIFACT_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningArtifactPreferences").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::provisioningArtifactPreferences)).setter(DescribeProvisioningParametersResponse.setter(Builder::provisioningArtifactPreferences)).constructor(ProvisioningArtifactPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactPreferences").build()}).build();
    private static final SdkField<List<ProvisioningArtifactOutput>> PROVISIONING_ARTIFACT_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningArtifactOutputs").getter(DescribeProvisioningParametersResponse.getter(DescribeProvisioningParametersResponse::provisioningArtifactOutputs)).setter(DescribeProvisioningParametersResponse.setter(Builder::provisioningArtifactOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifactOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_ARTIFACT_PARAMETERS_FIELD, CONSTRAINT_SUMMARIES_FIELD, USAGE_INSTRUCTIONS_FIELD, TAG_OPTIONS_FIELD, PROVISIONING_ARTIFACT_PREFERENCES_FIELD, PROVISIONING_ARTIFACT_OUTPUTS_FIELD));
    private final List<ProvisioningArtifactParameter> provisioningArtifactParameters;
    private final List<ConstraintSummary> constraintSummaries;
    private final List<UsageInstruction> usageInstructions;
    private final List<TagOptionSummary> tagOptions;
    private final ProvisioningArtifactPreferences provisioningArtifactPreferences;
    private final List<ProvisioningArtifactOutput> provisioningArtifactOutputs;

    private DescribeProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.constraintSummaries = builder.constraintSummaries;
        this.usageInstructions = builder.usageInstructions;
        this.tagOptions = builder.tagOptions;
        this.provisioningArtifactPreferences = builder.provisioningArtifactPreferences;
        this.provisioningArtifactOutputs = builder.provisioningArtifactOutputs;
    }

    public final boolean hasProvisioningArtifactParameters() {
        return this.provisioningArtifactParameters != null && !(this.provisioningArtifactParameters instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningArtifactParameter> provisioningArtifactParameters() {
        return this.provisioningArtifactParameters;
    }

    public final boolean hasConstraintSummaries() {
        return this.constraintSummaries != null && !(this.constraintSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConstraintSummary> constraintSummaries() {
        return this.constraintSummaries;
    }

    public final boolean hasUsageInstructions() {
        return this.usageInstructions != null && !(this.usageInstructions instanceof SdkAutoConstructList);
    }

    public final List<UsageInstruction> usageInstructions() {
        return this.usageInstructions;
    }

    public final boolean hasTagOptions() {
        return this.tagOptions != null && !(this.tagOptions instanceof SdkAutoConstructList);
    }

    public final List<TagOptionSummary> tagOptions() {
        return this.tagOptions;
    }

    public final ProvisioningArtifactPreferences provisioningArtifactPreferences() {
        return this.provisioningArtifactPreferences;
    }

    public final boolean hasProvisioningArtifactOutputs() {
        return this.provisioningArtifactOutputs != null && !(this.provisioningArtifactOutputs instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningArtifactOutput> provisioningArtifactOutputs() {
        return this.provisioningArtifactOutputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningArtifactParameters() ? this.provisioningArtifactParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConstraintSummaries() ? this.constraintSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageInstructions() ? this.usageInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagOptions() ? this.tagOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningArtifactOutputs() ? this.provisioningArtifactOutputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersResponse)) {
            return false;
        }
        DescribeProvisioningParametersResponse other = (DescribeProvisioningParametersResponse)((Object)obj);
        return this.hasProvisioningArtifactParameters() == other.hasProvisioningArtifactParameters() && Objects.equals(this.provisioningArtifactParameters(), other.provisioningArtifactParameters()) && this.hasConstraintSummaries() == other.hasConstraintSummaries() && Objects.equals(this.constraintSummaries(), other.constraintSummaries()) && this.hasUsageInstructions() == other.hasUsageInstructions() && Objects.equals(this.usageInstructions(), other.usageInstructions()) && this.hasTagOptions() == other.hasTagOptions() && Objects.equals(this.tagOptions(), other.tagOptions()) && Objects.equals(this.provisioningArtifactPreferences(), other.provisioningArtifactPreferences()) && this.hasProvisioningArtifactOutputs() == other.hasProvisioningArtifactOutputs() && Objects.equals(this.provisioningArtifactOutputs(), other.provisioningArtifactOutputs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProvisioningParametersResponse").add("ProvisioningArtifactParameters", this.hasProvisioningArtifactParameters() ? this.provisioningArtifactParameters() : null).add("ConstraintSummaries", this.hasConstraintSummaries() ? this.constraintSummaries() : null).add("UsageInstructions", this.hasUsageInstructions() ? this.usageInstructions() : null).add("TagOptions", this.hasTagOptions() ? this.tagOptions() : null).add("ProvisioningArtifactPreferences", (Object)this.provisioningArtifactPreferences()).add("ProvisioningArtifactOutputs", this.hasProvisioningArtifactOutputs() ? this.provisioningArtifactOutputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactParameters()));
            }
            case "ConstraintSummaries": {
                return Optional.ofNullable(clazz.cast(this.constraintSummaries()));
            }
            case "UsageInstructions": {
                return Optional.ofNullable(clazz.cast(this.usageInstructions()));
            }
            case "TagOptions": {
                return Optional.ofNullable(clazz.cast(this.tagOptions()));
            }
            case "ProvisioningArtifactPreferences": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactPreferences()));
            }
            case "ProvisioningArtifactOutputs": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactOutputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactParameter> provisioningArtifactParameters = DefaultSdkAutoConstructList.getInstance();
        private List<ConstraintSummary> constraintSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<UsageInstruction> usageInstructions = DefaultSdkAutoConstructList.getInstance();
        private List<TagOptionSummary> tagOptions = DefaultSdkAutoConstructList.getInstance();
        private ProvisioningArtifactPreferences provisioningArtifactPreferences;
        private List<ProvisioningArtifactOutput> provisioningArtifactOutputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersResponse model) {
            super(model);
            this.provisioningArtifactParameters(model.provisioningArtifactParameters);
            this.constraintSummaries(model.constraintSummaries);
            this.usageInstructions(model.usageInstructions);
            this.tagOptions(model.tagOptions);
            this.provisioningArtifactPreferences(model.provisioningArtifactPreferences);
            this.provisioningArtifactOutputs(model.provisioningArtifactOutputs);
        }

        public final List<ProvisioningArtifactParameter.Builder> getProvisioningArtifactParameters() {
            List<ProvisioningArtifactParameter.Builder> result = ProvisioningArtifactParametersCopier.copyToBuilder(this.provisioningArtifactParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... provisioningArtifactParameters) {
            this.provisioningArtifactParameters(Arrays.asList(provisioningArtifactParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder> ... provisioningArtifactParameters) {
            this.provisioningArtifactParameters(Stream.of(provisioningArtifactParameters).map(c -> (ProvisioningArtifactParameter)((ProvisioningArtifactParameter.Builder)ProvisioningArtifactParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactParameters(Collection<ProvisioningArtifactParameter.BuilderImpl> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copyFromBuilder(provisioningArtifactParameters);
        }

        public final List<ConstraintSummary.Builder> getConstraintSummaries() {
            List<ConstraintSummary.Builder> result = ConstraintSummariesCopier.copyToBuilder(this.constraintSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary ... constraintSummaries) {
            this.constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(Consumer<ConstraintSummary.Builder> ... constraintSummaries) {
            this.constraintSummaries(Stream.of(constraintSummaries).map(c -> (ConstraintSummary)((ConstraintSummary.Builder)ConstraintSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        public final List<UsageInstruction.Builder> getUsageInstructions() {
            List<UsageInstruction.Builder> result = UsageInstructionsCopier.copyToBuilder(this.usageInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder usageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(UsageInstruction ... usageInstructions) {
            this.usageInstructions(Arrays.asList(usageInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(Consumer<UsageInstruction.Builder> ... usageInstructions) {
            this.usageInstructions(Stream.of(usageInstructions).map(c -> (UsageInstruction)((UsageInstruction.Builder)UsageInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsageInstructions(Collection<UsageInstruction.BuilderImpl> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copyFromBuilder(usageInstructions);
        }

        public final List<TagOptionSummary.Builder> getTagOptions() {
            List<TagOptionSummary.Builder> result = TagOptionSummariesCopier.copyToBuilder(this.tagOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionSummary> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionSummary ... tagOptions) {
            this.tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionSummary.Builder> ... tagOptions) {
            this.tagOptions(Stream.of(tagOptions).map(c -> (TagOptionSummary)((TagOptionSummary.Builder)TagOptionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionSummary.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copyFromBuilder(tagOptions);
        }

        public final ProvisioningArtifactPreferences.Builder getProvisioningArtifactPreferences() {
            return this.provisioningArtifactPreferences != null ? this.provisioningArtifactPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences;
            return this;
        }

        public final void setProvisioningArtifactPreferences(ProvisioningArtifactPreferences.BuilderImpl provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences != null ? provisioningArtifactPreferences.build() : null;
        }

        public final List<ProvisioningArtifactOutput.Builder> getProvisioningArtifactOutputs() {
            List<ProvisioningArtifactOutput.Builder> result = ProvisioningArtifactOutputsCopier.copyToBuilder(this.provisioningArtifactOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder provisioningArtifactOutputs(Collection<ProvisioningArtifactOutput> provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs = ProvisioningArtifactOutputsCopier.copy(provisioningArtifactOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactOutputs(ProvisioningArtifactOutput ... provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs(Arrays.asList(provisioningArtifactOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactOutputs(Consumer<ProvisioningArtifactOutput.Builder> ... provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs(Stream.of(provisioningArtifactOutputs).map(c -> (ProvisioningArtifactOutput)((ProvisioningArtifactOutput.Builder)ProvisioningArtifactOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactOutputs(Collection<ProvisioningArtifactOutput.BuilderImpl> provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs = ProvisioningArtifactOutputsCopier.copyFromBuilder(provisioningArtifactOutputs);
        }

        @Override
        public DescribeProvisioningParametersResponse build() {
            return new DescribeProvisioningParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
        public Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> var1);

        public Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... var1);

        public Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder> ... var1);

        public Builder constraintSummaries(Collection<ConstraintSummary> var1);

        public Builder constraintSummaries(ConstraintSummary ... var1);

        public Builder constraintSummaries(Consumer<ConstraintSummary.Builder> ... var1);

        public Builder usageInstructions(Collection<UsageInstruction> var1);

        public Builder usageInstructions(UsageInstruction ... var1);

        public Builder usageInstructions(Consumer<UsageInstruction.Builder> ... var1);

        public Builder tagOptions(Collection<TagOptionSummary> var1);

        public Builder tagOptions(TagOptionSummary ... var1);

        public Builder tagOptions(Consumer<TagOptionSummary.Builder> ... var1);

        public Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences var1);

        default public Builder provisioningArtifactPreferences(Consumer<ProvisioningArtifactPreferences.Builder> provisioningArtifactPreferences) {
            return this.provisioningArtifactPreferences((ProvisioningArtifactPreferences)((ProvisioningArtifactPreferences.Builder)ProvisioningArtifactPreferences.builder().applyMutation(provisioningArtifactPreferences)).build());
        }

        public Builder provisioningArtifactOutputs(Collection<ProvisioningArtifactOutput> var1);

        public Builder provisioningArtifactOutputs(ProvisioningArtifactOutput ... var1);

        public Builder provisioningArtifactOutputs(Consumer<ProvisioningArtifactOutput.Builder> ... var1);
    }
}

