/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Range
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Range> {
    private static final SdkField<Long> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Start").getter(Range.getter(Range::start)).setter(Range.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()}).build();
    private static final SdkField<Long> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("End").getter(Range.getter(Range::end)).setter(Range.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()}).build();
    private static final SdkField<Long> START_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartColumn").getter(Range.getter(Range::startColumn)).setter(Range.setter(Builder::startColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartColumn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD, START_COLUMN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long start;
    private final Long end;
    private final Long startColumn;

    private Range(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.startColumn = builder.startColumn;
    }

    public final Long start() {
        return this.start;
    }

    public final Long end() {
        return this.end;
    }

    public final Long startColumn() {
        return this.startColumn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.startColumn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.startColumn(), other.startColumn());
    }

    public final String toString() {
        return ToString.builder((String)"Range").add("Start", (Object)this.start()).add("End", (Object)this.end()).add("StartColumn", (Object)this.startColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "StartColumn": {
                return Optional.ofNullable(clazz.cast(this.startColumn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long start;
        private Long end;
        private Long startColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            this.start(model.start);
            this.end(model.end);
            this.startColumn(model.startColumn);
        }

        public final Long getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final Long getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Long end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Long end) {
            this.end = end;
        }

        public final Long getStartColumn() {
            return this.startColumn;
        }

        @Override
        public final Builder startColumn(Long startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public final void setStartColumn(Long startColumn) {
            this.startColumn = startColumn;
        }

        public Range build() {
            return new Range(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Range> {
        public Builder start(Long var1);

        public Builder end(Long var1);

        public Builder startColumn(Long var1);
    }
}

