/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayEndpointConfiguration;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiGatewayRestApiDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiGatewayRestApiDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::id)).setter(AwsApiGatewayRestApiDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::name)).setter(AwsApiGatewayRestApiDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::description)).setter(AwsApiGatewayRestApiDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::createdDate)).setter(AwsApiGatewayRestApiDetails.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::version)).setter(AwsApiGatewayRestApiDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BinaryMediaTypes").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::binaryMediaTypes)).setter(AwsApiGatewayRestApiDetails.setter(Builder::binaryMediaTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryMediaTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumCompressionSize").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::minimumCompressionSize)).setter(AwsApiGatewayRestApiDetails.setter(Builder::minimumCompressionSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumCompressionSize").build()}).build();
    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKeySource").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::apiKeySource)).setter(AwsApiGatewayRestApiDetails.setter(Builder::apiKeySource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeySource").build()}).build();
    private static final SdkField<AwsApiGatewayEndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(AwsApiGatewayRestApiDetails.getter(AwsApiGatewayRestApiDetails::endpointConfiguration)).setter(AwsApiGatewayRestApiDetails.setter(Builder::endpointConfiguration)).constructor(AwsApiGatewayEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, BINARY_MEDIA_TYPES_FIELD, MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String createdDate;
    private final String version;
    private final List<String> binaryMediaTypes;
    private final Integer minimumCompressionSize;
    private final String apiKeySource;
    private final AwsApiGatewayEndpointConfiguration endpointConfiguration;

    private AwsApiGatewayRestApiDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasBinaryMediaTypes() {
        return this.binaryMediaTypes != null && !(this.binaryMediaTypes instanceof SdkAutoConstructList);
    }

    public final List<String> binaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public final Integer minimumCompressionSize() {
        return this.minimumCompressionSize;
    }

    public final String apiKeySource() {
        return this.apiKeySource;
    }

    public final AwsApiGatewayEndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySource());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayRestApiDetails)) {
            return false;
        }
        AwsApiGatewayRestApiDetails other = (AwsApiGatewayRestApiDetails)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && this.hasBinaryMediaTypes() == other.hasBinaryMediaTypes() && Objects.equals(this.binaryMediaTypes(), other.binaryMediaTypes()) && Objects.equals(this.minimumCompressionSize(), other.minimumCompressionSize()) && Objects.equals(this.apiKeySource(), other.apiKeySource()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiGatewayRestApiDetails").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("BinaryMediaTypes", this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null).add("MinimumCompressionSize", (Object)this.minimumCompressionSize()).add("ApiKeySource", (Object)this.apiKeySource()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "BinaryMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.binaryMediaTypes()));
            }
            case "MinimumCompressionSize": {
                return Optional.ofNullable(clazz.cast(this.minimumCompressionSize()));
            }
            case "ApiKeySource": {
                return Optional.ofNullable(clazz.cast(this.apiKeySource()));
            }
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayRestApiDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayRestApiDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String createdDate;
        private String version;
        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer minimumCompressionSize;
        private String apiKeySource;
        private AwsApiGatewayEndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayRestApiDetails model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.binaryMediaTypes(model.binaryMediaTypes);
            this.minimumCompressionSize(model.minimumCompressionSize);
            this.apiKeySource(model.apiKeySource);
            this.endpointConfiguration(model.endpointConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getBinaryMediaTypes() {
            if (this.binaryMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = NonEmptyStringListCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String ... binaryMediaTypes) {
            this.binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = NonEmptyStringListCopier.copy(binaryMediaTypes);
        }

        public final Integer getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        public final String getApiKeySource() {
            return this.apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        public final AwsApiGatewayEndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(AwsApiGatewayEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(AwsApiGatewayEndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        public AwsApiGatewayRestApiDetails build() {
            return new AwsApiGatewayRestApiDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiGatewayRestApiDetails> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdDate(String var1);

        public Builder version(String var1);

        public Builder binaryMediaTypes(Collection<String> var1);

        public Builder binaryMediaTypes(String ... var1);

        public Builder minimumCompressionSize(Integer var1);

        public Builder apiKeySource(String var1);

        public Builder endpointConfiguration(AwsApiGatewayEndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<AwsApiGatewayEndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((AwsApiGatewayEndpointConfiguration)((AwsApiGatewayEndpointConfiguration.Builder)AwsApiGatewayEndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }
    }
}

