/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary;
import software.amazon.awssdk.services.schemas.model.___listOfSearchSchemaVersionSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSchemaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchSchemaSummary> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(SearchSchemaSummary.getter(SearchSchemaSummary::registryName)).setter(SearchSchemaSummary.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(SearchSchemaSummary.getter(SearchSchemaSummary::schemaArn)).setter(SearchSchemaSummary.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(SearchSchemaSummary.getter(SearchSchemaSummary::schemaName)).setter(SearchSchemaSummary.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<List<SearchSchemaVersionSummary>> SCHEMA_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaVersions").getter(SearchSchemaSummary.getter(SearchSchemaSummary::schemaVersions)).setter(SearchSchemaSummary.setter(Builder::schemaVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSchemaVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_VERSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryName;
    private final String schemaArn;
    private final String schemaName;
    private final List<SearchSchemaVersionSummary> schemaVersions;

    private SearchSchemaSummary(BuilderImpl builder) {
        this.registryName = builder.registryName;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.schemaVersions = builder.schemaVersions;
    }

    public final String registryName() {
        return this.registryName;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final boolean hasSchemaVersions() {
        return this.schemaVersions != null && !(this.schemaVersions instanceof SdkAutoConstructList);
    }

    public final List<SearchSchemaVersionSummary> schemaVersions() {
        return this.schemaVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaVersions() ? this.schemaVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSchemaSummary)) {
            return false;
        }
        SearchSchemaSummary other = (SearchSchemaSummary)obj;
        return Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaName(), other.schemaName()) && this.hasSchemaVersions() == other.hasSchemaVersions() && Objects.equals(this.schemaVersions(), other.schemaVersions());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSchemaSummary").add("RegistryName", (Object)this.registryName()).add("SchemaArn", (Object)this.schemaArn()).add("SchemaName", (Object)this.schemaName()).add("SchemaVersions", this.hasSchemaVersions() ? this.schemaVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "SchemaVersions": {
                return Optional.ofNullable(clazz.cast(this.schemaVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSchemaSummary, T> g) {
        return obj -> g.apply((SearchSchemaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryName;
        private String schemaArn;
        private String schemaName;
        private List<SearchSchemaVersionSummary> schemaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSchemaSummary model) {
            this.registryName(model.registryName);
            this.schemaArn(model.schemaArn);
            this.schemaName(model.schemaName);
            this.schemaVersions(model.schemaVersions);
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final List<SearchSchemaVersionSummary.Builder> getSchemaVersions() {
            List<SearchSchemaVersionSummary.Builder> result = ___listOfSearchSchemaVersionSummaryCopier.copyToBuilder(this.schemaVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder schemaVersions(Collection<SearchSchemaVersionSummary> schemaVersions) {
            this.schemaVersions = ___listOfSearchSchemaVersionSummaryCopier.copy(schemaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(SearchSchemaVersionSummary ... schemaVersions) {
            this.schemaVersions(Arrays.asList(schemaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(Consumer<SearchSchemaVersionSummary.Builder> ... schemaVersions) {
            this.schemaVersions(Stream.of(schemaVersions).map(c -> (SearchSchemaVersionSummary)((SearchSchemaVersionSummary.Builder)SearchSchemaVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaVersions(Collection<SearchSchemaVersionSummary.BuilderImpl> schemaVersions) {
            this.schemaVersions = ___listOfSearchSchemaVersionSummaryCopier.copyFromBuilder(schemaVersions);
        }

        public SearchSchemaSummary build() {
            return new SearchSchemaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchSchemaSummary> {
        public Builder registryName(String var1);

        public Builder schemaArn(String var1);

        public Builder schemaName(String var1);

        public Builder schemaVersions(Collection<SearchSchemaVersionSummary> var1);

        public Builder schemaVersions(SearchSchemaVersionSummary ... var1);

        public Builder schemaVersions(Consumer<SearchSchemaVersionSummary.Builder> ... var1);
    }
}

