/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3Permission {
    FULL_CONTROL("FULL_CONTROL"),
    READ("READ"),
    WRITE("WRITE"),
    READ_ACP("READ_ACP"),
    WRITE_ACP("WRITE_ACP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3Permission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3Permission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3Permission.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3Permission> knownValues() {
        return Stream.of(S3Permission.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

