/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.resource.S3ResourceType;
import software.amazon.awssdk.services.s3control.internal.S3ControlResourceType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class S3ControlBucketResource
implements S3Resource {
    private final String partition;
    private final String region;
    private final String accountId;
    private final String bucketName;
    private final S3Resource parentS3Resource;

    private S3ControlBucketResource(Builder b) {
        this.bucketName = (String)Validate.notBlank((CharSequence)b.bucketName, (String)"bucketName", (Object[])new Object[0]);
        if (b.parentS3Resource == null) {
            this.parentS3Resource = null;
            this.partition = b.partition;
            this.region = b.region;
            this.accountId = b.accountId;
        } else {
            this.parentS3Resource = this.validateParentS3Resource(b.parentS3Resource);
            Validate.isNull((Object)b.partition, (String)"partition cannot be set on builder if it has parent resource", (Object[])new Object[0]);
            Validate.isNull((Object)b.region, (String)"region cannot be set on builder if it has parent resource", (Object[])new Object[0]);
            Validate.isNull((Object)b.accountId, (String)"accountId cannot be set on builder if it has parent resource", (Object[])new Object[0]);
            this.partition = this.parentS3Resource.partition().orElse(null);
            this.region = this.parentS3Resource.region().orElse(null);
            this.accountId = this.parentS3Resource.accountId().orElse(null);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String type() {
        return S3ControlResourceType.BUCKET.toString();
    }

    public Optional<String> partition() {
        return Optional.of(this.partition);
    }

    public Optional<String> region() {
        return Optional.of(this.region);
    }

    public Optional<String> accountId() {
        return Optional.of(this.accountId);
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Optional<S3Resource> parentS3Resource() {
        return Optional.ofNullable(this.parentS3Resource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ControlBucketResource that = (S3ControlBucketResource)o;
        if (!Objects.equals(this.partition, that.partition)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!this.bucketName.equals(that.bucketName)) {
            return false;
        }
        return Objects.equals(this.parentS3Resource, that.parentS3Resource);
    }

    public int hashCode() {
        int result = this.partition != null ? this.partition.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + this.bucketName.hashCode();
        result = 31 * result + (this.parentS3Resource != null ? this.parentS3Resource.hashCode() : 0);
        return result;
    }

    private S3Resource validateParentS3Resource(S3Resource parentS3Resource) {
        if (!S3ResourceType.OUTPOST.toString().equals(parentS3Resource.type())) {
            throw new IllegalArgumentException("Invalid 'parentS3Resource' type. An S3 bucket resource must be associated with an outpost parent resource.");
        }
        return parentS3Resource;
    }

    public static final class Builder {
        private String partition;
        private String region;
        private String accountId;
        private String bucketName;
        private S3Resource parentS3Resource;

        private Builder() {
        }

        public Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder parentS3Resource(S3Resource parentS3Resource) {
            this.parentS3Resource = parentS3Resource;
            return this;
        }

        public S3ControlBucketResource build() {
            return new S3ControlBucketResource(this);
        }
    }
}

