/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class UploadPartRequestMarshaller
implements Marshaller<Request<UploadPartRequest>, UploadPartRequest> {
    public Request<UploadPartRequest> marshall(UploadPartRequest uploadPartRequest) {
        if (uploadPartRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)uploadPartRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadPartRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringConversion.fromLong((Long)uploadPartRequest.contentLength()));
        }
        if (uploadPartRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)uploadPartRequest.contentMD5()));
        }
        if (uploadPartRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)uploadPartRequest.sseCustomerAlgorithm()));
        }
        if (uploadPartRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)uploadPartRequest.sseCustomerKey()));
        }
        if (uploadPartRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)uploadPartRequest.sseCustomerKeyMD5()));
        }
        if (uploadPartRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)uploadPartRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", uploadPartRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", uploadPartRequest.key());
        request.setResourcePath(uriResourcePath);
        if (uploadPartRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger((Integer)uploadPartRequest.partNumber()));
        }
        if (uploadPartRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString((String)uploadPartRequest.uploadId()));
        }
        return request;
    }
}

