/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;

public class UploadPartCopyRequestMarshaller
implements Marshaller<Request<UploadPartCopyRequest>, UploadPartCopyRequest> {
    public Request<UploadPartCopyRequest> marshall(UploadPartCopyRequest uploadPartCopyRequest) {
        if (uploadPartCopyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)uploadPartCopyRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadPartCopyRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringConversion.fromString((String)uploadPartCopyRequest.copySource()));
        }
        if (uploadPartCopyRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringConversion.fromString((String)uploadPartCopyRequest.copySourceIfMatch()));
        }
        if (uploadPartCopyRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since", StringConversion.fromInstant((Instant)uploadPartCopyRequest.copySourceIfModifiedSince()));
        }
        if (uploadPartCopyRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match", StringConversion.fromString((String)uploadPartCopyRequest.copySourceIfNoneMatch()));
        }
        if (uploadPartCopyRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since", StringConversion.fromInstant((Instant)uploadPartCopyRequest.copySourceIfUnmodifiedSince()));
        }
        if (uploadPartCopyRequest.copySourceRange() != null) {
            request.addHeader("x-amz-copy-source-range", StringConversion.fromString((String)uploadPartCopyRequest.copySourceRange()));
        }
        if (uploadPartCopyRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)uploadPartCopyRequest.sseCustomerAlgorithm()));
        }
        if (uploadPartCopyRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)uploadPartCopyRequest.sseCustomerKey()));
        }
        if (uploadPartCopyRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)uploadPartCopyRequest.sseCustomerKeyMD5()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", StringConversion.fromString((String)uploadPartCopyRequest.copySourceSSECustomerAlgorithm()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key", StringConversion.fromString((String)uploadPartCopyRequest.copySourceSSECustomerKey()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)uploadPartCopyRequest.copySourceSSECustomerKeyMD5()));
        }
        if (uploadPartCopyRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)uploadPartCopyRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", uploadPartCopyRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", uploadPartCopyRequest.key());
        request.setResourcePath(uriResourcePath);
        if (uploadPartCopyRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger((Integer)uploadPartCopyRequest.partNumber()));
        }
        if (uploadPartCopyRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString((String)uploadPartCopyRequest.uploadId()));
        }
        return request;
    }
}

