/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketTaggingRequestMarshaller
implements Marshaller<Request<PutBucketTaggingRequest>, PutBucketTaggingRequest> {
    public Request<PutBucketTaggingRequest> marshall(PutBucketTaggingRequest putBucketTaggingRequest) {
        if (putBucketTaggingRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketTaggingRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putBucketTaggingRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketTaggingRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            Tagging tagging = putBucketTaggingRequest.tagging();
            if (tagging != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("Tagging");
                List<Tag> taggingTagSetList = tagging.tagSet();
                if (!taggingTagSetList.isEmpty() || !(taggingTagSetList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("TagSet");
                    for (Tag taggingTagSetListValue : taggingTagSetList) {
                        xmlWriter.startElement("Tag");
                        if (taggingTagSetListValue.key() != null) {
                            xmlWriter.startElement("Key").value(taggingTagSetListValue.key()).endElement();
                        }
                        if (taggingTagSetListValue.value() != null) {
                            xmlWriter.startElement("Value").value(taggingTagSetListValue.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

