/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;

public class DeleteBucketMetricsConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketMetricsConfigurationRequest>, DeleteBucketMetricsConfigurationRequest> {
    public Request<DeleteBucketMetricsConfigurationRequest> marshall(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) {
        if (deleteBucketMetricsConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteBucketMetricsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketMetricsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketMetricsConfigurationRequest.id() != null) {
            request.addParameter("id", StringConversion.fromString((String)deleteBucketMetricsConfigurationRequest.id()));
        }
        return request;
    }
}

