/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;

public class CopyObjectRequestMarshaller
implements Marshaller<Request<CopyObjectRequest>, CopyObjectRequest> {
    public Request<CopyObjectRequest> marshall(CopyObjectRequest copyObjectRequest) {
        if (copyObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (copyObjectRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString((String)copyObjectRequest.aclAsString()));
        }
        if (copyObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringConversion.fromString((String)copyObjectRequest.cacheControl()));
        }
        if (copyObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringConversion.fromString((String)copyObjectRequest.contentDisposition()));
        }
        if (copyObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringConversion.fromString((String)copyObjectRequest.contentEncoding()));
        }
        if (copyObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringConversion.fromString((String)copyObjectRequest.contentLanguage()));
        }
        if (copyObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringConversion.fromString((String)copyObjectRequest.contentType()));
        }
        if (copyObjectRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringConversion.fromString((String)copyObjectRequest.copySource()));
        }
        if (copyObjectRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringConversion.fromString((String)copyObjectRequest.copySourceIfMatch()));
        }
        if (copyObjectRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since", StringConversion.fromInstant((Instant)copyObjectRequest.copySourceIfModifiedSince()));
        }
        if (copyObjectRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match", StringConversion.fromString((String)copyObjectRequest.copySourceIfNoneMatch()));
        }
        if (copyObjectRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since", StringConversion.fromInstant((Instant)copyObjectRequest.copySourceIfUnmodifiedSince()));
        }
        if (copyObjectRequest.expires() != null) {
            request.addHeader("Expires", StringConversion.fromInstant((Instant)copyObjectRequest.expires()));
        }
        if (copyObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString((String)copyObjectRequest.grantFullControl()));
        }
        if (copyObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString((String)copyObjectRequest.grantRead()));
        }
        if (copyObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString((String)copyObjectRequest.grantReadACP()));
        }
        if (copyObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString((String)copyObjectRequest.grantWriteACP()));
        }
        if (copyObjectRequest.metadataDirectiveAsString() != null) {
            request.addHeader("x-amz-metadata-directive", StringConversion.fromString((String)copyObjectRequest.metadataDirectiveAsString()));
        }
        if (copyObjectRequest.taggingDirectiveAsString() != null) {
            request.addHeader("x-amz-tagging-directive", StringConversion.fromString((String)copyObjectRequest.taggingDirectiveAsString()));
        }
        if (copyObjectRequest.serverSideEncryptionAsString() != null) {
            request.addHeader("x-amz-server-side-encryption", StringConversion.fromString((String)copyObjectRequest.serverSideEncryptionAsString()));
        }
        if (copyObjectRequest.storageClassAsString() != null) {
            request.addHeader("x-amz-storage-class", StringConversion.fromString((String)copyObjectRequest.storageClassAsString()));
        }
        if (copyObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringConversion.fromString((String)copyObjectRequest.websiteRedirectLocation()));
        }
        if (copyObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)copyObjectRequest.sseCustomerAlgorithm()));
        }
        if (copyObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)copyObjectRequest.sseCustomerKey()));
        }
        if (copyObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)copyObjectRequest.sseCustomerKeyMD5()));
        }
        if (copyObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringConversion.fromString((String)copyObjectRequest.ssekmsKeyId()));
        }
        if (copyObjectRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", StringConversion.fromString((String)copyObjectRequest.copySourceSSECustomerAlgorithm()));
        }
        if (copyObjectRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key", StringConversion.fromString((String)copyObjectRequest.copySourceSSECustomerKey()));
        }
        if (copyObjectRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)copyObjectRequest.copySourceSSECustomerKeyMD5()));
        }
        if (copyObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)copyObjectRequest.requestPayerAsString()));
        }
        if (copyObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringConversion.fromString((String)copyObjectRequest.tagging()));
        }
        if (copyObjectRequest.metadata() != null) {
            copyObjectRequest.metadata().entrySet().forEach(arg_0 -> CopyObjectRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", copyObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", copyObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

