/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectsV2Request
extends S3Request
implements ToCopyableBuilder<Builder, ListObjectsV2Request> {
    private final String bucket;
    private final String delimiter;
    private final String encodingType;
    private final Integer maxKeys;
    private final String prefix;
    private final String continuationToken;
    private final Boolean fetchOwner;
    private final String startAfter;
    private final String requestPayer;

    private ListObjectsV2Request(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.fetchOwner = builder.fetchOwner;
        this.startAfter = builder.startAfter;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public EncodingType encodingType() {
        return EncodingType.fromValue(this.encodingType);
    }

    public String encodingTypeAsString() {
        return this.encodingType;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public String prefix() {
        return this.prefix;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public Boolean fetchOwner() {
        return this.fetchOwner;
    }

    public String startAfter() {
        return this.startAfter;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerAsString() {
        return this.requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fetchOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsV2Request)) {
            return false;
        }
        ListObjectsV2Request other = (ListObjectsV2Request)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.encodingTypeAsString(), other.encodingTypeAsString()) && Objects.equals(this.maxKeys(), other.maxKeys()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.fetchOwner(), other.fetchOwner()) && Objects.equals(this.startAfter(), other.startAfter()) && Objects.equals(this.requestPayerAsString(), other.requestPayerAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectsV2Request").add("Bucket", (Object)this.bucket()).add("Delimiter", (Object)this.delimiter()).add("EncodingType", (Object)this.encodingTypeAsString()).add("MaxKeys", (Object)this.maxKeys()).add("Prefix", (Object)this.prefix()).add("ContinuationToken", (Object)this.continuationToken()).add("FetchOwner", (Object)this.fetchOwner()).add("StartAfter", (Object)this.startAfter()).add("RequestPayer", (Object)this.requestPayerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "EncodingType": {
                return Optional.ofNullable(clazz.cast(this.encodingTypeAsString()));
            }
            case "MaxKeys": {
                return Optional.ofNullable(clazz.cast(this.maxKeys()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "FetchOwner": {
                return Optional.ofNullable(clazz.cast(this.fetchOwner()));
            }
            case "StartAfter": {
                return Optional.ofNullable(clazz.cast(this.startAfter()));
            }
            case "RequestPayer": {
                return Optional.ofNullable(clazz.cast(this.requestPayerAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private Integer maxKeys;
        private String prefix;
        private String continuationToken;
        private Boolean fetchOwner;
        private String startAfter;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsV2Request model) {
            super(model);
            this.bucket(model.bucket);
            this.delimiter(model.delimiter);
            this.encodingType(model.encodingType);
            this.maxKeys(model.maxKeys);
            this.prefix(model.prefix);
            this.continuationToken(model.continuationToken);
            this.fetchOwner(model.fetchOwner);
            this.startAfter(model.startAfter);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Boolean getFetchOwner() {
            return this.fetchOwner;
        }

        @Override
        public final Builder fetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
            return this;
        }

        public final void setFetchOwner(Boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
        }

        public final String getStartAfter() {
            return this.startAfter;
        }

        @Override
        public final Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public final void setStartAfter(String startAfter) {
            this.startAfter = startAfter;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectsV2Request build() {
            return new ListObjectsV2Request(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, ListObjectsV2Request> {
        public Builder bucket(String var1);

        public Builder delimiter(String var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder maxKeys(Integer var1);

        public Builder prefix(String var1);

        public Builder continuationToken(String var1);

        public Builder fetchOwner(Boolean var1);

        public Builder startAfter(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

