/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiAsyncClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesResponse;

public class GetTagValuesPublisher
implements SdkPublisher<GetTagValuesResponse> {
    private final ResourceGroupsTaggingApiAsyncClient client;
    private final GetTagValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTagValuesPublisher(ResourceGroupsTaggingApiAsyncClient client, GetTagValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTagValuesPublisher(ResourceGroupsTaggingApiAsyncClient client, GetTagValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTagValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTagValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> tagValues() {
        Function<GetTagValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagValues() != null) {
                return response.tagValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTagValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTagValuesResponseFetcher
    implements AsyncPageFetcher<GetTagValuesResponse> {
        private GetTagValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetTagValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public CompletableFuture<GetTagValuesResponse> nextPage(GetTagValuesResponse previousPage) {
            if (previousPage == null) {
                return GetTagValuesPublisher.this.client.getTagValues(GetTagValuesPublisher.this.firstRequest);
            }
            return GetTagValuesPublisher.this.client.getTagValues((GetTagValuesRequest)((Object)GetTagValuesPublisher.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

