/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiAsyncClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysResponse;

public class GetTagKeysPublisher
implements SdkPublisher<GetTagKeysResponse> {
    private final ResourceGroupsTaggingApiAsyncClient client;
    private final GetTagKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTagKeysPublisher(ResourceGroupsTaggingApiAsyncClient client, GetTagKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTagKeysPublisher(ResourceGroupsTaggingApiAsyncClient client, GetTagKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTagKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTagKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> tagKeys() {
        Function<GetTagKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagKeys() != null) {
                return response.tagKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetTagKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetTagKeysResponseFetcher
    implements AsyncPageFetcher<GetTagKeysResponse> {
        private GetTagKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetTagKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public CompletableFuture<GetTagKeysResponse> nextPage(GetTagKeysResponse previousPage) {
            if (previousPage == null) {
                return GetTagKeysPublisher.this.client.getTagKeys(GetTagKeysPublisher.this.firstRequest);
            }
            return GetTagKeysPublisher.this.client.getTagKeys((GetTagKeysRequest)((Object)GetTagKeysPublisher.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

