/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceARNListForTagUntagCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagKeyListForUntagCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagResourcesRequest
extends ResourceGroupsTaggingApiRequest
implements ToCopyableBuilder<Builder, UntagResourcesRequest> {
    private static final SdkField<List<String>> RESOURCE_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceARNList").getter(UntagResourcesRequest.getter(UntagResourcesRequest::resourceARNList)).setter(UntagResourcesRequest.setter(Builder::resourceARNList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeys").getter(UntagResourcesRequest.getter(UntagResourcesRequest::tagKeys)).setter(UntagResourcesRequest.setter(Builder::tagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_LIST_FIELD, TAG_KEYS_FIELD));
    private final List<String> resourceARNList;
    private final List<String> tagKeys;

    private UntagResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceARNList = builder.resourceARNList;
        this.tagKeys = builder.tagKeys;
    }

    public final boolean hasResourceARNList() {
        return this.resourceARNList != null && !(this.resourceARNList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceARNList() {
        return this.resourceARNList;
    }

    public final boolean hasTagKeys() {
        return this.tagKeys != null && !(this.tagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceARNList() ? this.resourceARNList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeys() ? this.tagKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourcesRequest)) {
            return false;
        }
        UntagResourcesRequest other = (UntagResourcesRequest)((Object)obj);
        return this.hasResourceARNList() == other.hasResourceARNList() && Objects.equals(this.resourceARNList(), other.resourceARNList()) && this.hasTagKeys() == other.hasTagKeys() && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public final String toString() {
        return ToString.builder((String)"UntagResourcesRequest").add("ResourceARNList", this.hasResourceARNList() ? this.resourceARNList() : null).add("TagKeys", this.hasTagKeys() ? this.tagKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARNList": {
                return Optional.ofNullable(clazz.cast(this.resourceARNList()));
            }
            case "TagKeys": {
                return Optional.ofNullable(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagResourcesRequest, T> g) {
        return obj -> g.apply((UntagResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiRequest.BuilderImpl
    implements Builder {
        private List<String> resourceARNList = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourcesRequest model) {
            super(model);
            this.resourceARNList(model.resourceARNList);
            this.tagKeys(model.tagKeys);
        }

        public final Collection<String> getResourceARNList() {
            if (this.resourceARNList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceARNList;
        }

        @Override
        public final Builder resourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForTagUntagCopier.copy(resourceARNList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceARNList(String ... resourceARNList) {
            this.resourceARNList(Arrays.asList(resourceARNList));
            return this;
        }

        public final void setResourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForTagUntagCopier.copy(resourceARNList);
        }

        public final Collection<String> getTagKeys() {
            if (this.tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListForUntagCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListForUntagCopier.copy(tagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UntagResourcesRequest build() {
            return new UntagResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UntagResourcesRequest> {
        public Builder resourceARNList(Collection<String> var1);

        public Builder resourceARNList(String ... var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

